"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableToDashboardDrilldown = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/dashboard-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _public3 = require("@kbn/data-plugin/public");
var _public4 = require("@kbn/image-embeddable-plugin/public");
var _abstract_dashboard_drilldown = require("../abstract_dashboard_drilldown");
var _constants = require("./constants");
var _common = require("../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This drilldown is the "Go to Dashboard" you can find in Dashboard app panles.
 * This drilldown can be used on any embeddable and it is tied to embeddables
 * in two ways: (1) it works with APPLY_FILTER_TRIGGER, which is usually executed
 * by embeddables (but not necessarily); (2) its `getURL` method depends on
 * `embeddable` field being present in `context`.
 */
class EmbeddableToDashboardDrilldown extends _abstract_dashboard_drilldown.AbstractDashboardDrilldown {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "id", _constants.EMBEDDABLE_TO_DASHBOARD_DRILLDOWN);
    (0, _defineProperty2.default)(this, "supportedTriggers", () => [_public3.APPLY_FILTER_TRIGGER, _public4.IMAGE_CLICK_TRIGGER]);
    (0, _defineProperty2.default)(this, "inject", (0, _common.createInject)({
      drilldownId: this.id
    }));
    (0, _defineProperty2.default)(this, "extract", (0, _common.createExtract)({
      drilldownId: this.id
    }));
  }
  async getLocation(config, context, useUrlForState) {
    const params = {
      dashboardId: config.dashboardId
    };
    if (context.embeddable) {
      var _input$filters;
      const embeddable = context.embeddable;
      const input = embeddable.getInput();
      if ((0, _public3.isQuery)(input.query) && config.useCurrentFilters) params.query = input.query;

      // if useCurrentDashboardDataRange is enabled, then preserve current time range
      // if undefined is passed, then destination dashboard will figure out time range itself
      // for brush event this time range would be overwritten
      if ((0, _public3.isTimeRange)(input.timeRange) && config.useCurrentDateRange) params.timeRange = input.timeRange;

      // if useCurrentDashboardFilters enabled, then preserve all the filters (pinned, unpinned, and from controls)
      // otherwise preserve only pinned
      params.filters = config.useCurrentFilters ? input.filters : (_input$filters = input.filters) === null || _input$filters === void 0 ? void 0 : _input$filters.filter(f => (0, _esQuery.isFilterPinned)(f));
    }
    const {
      restOfFilters: filtersFromEvent,
      timeRange: timeRangeFromEvent
    } = (0, _esQuery.extractTimeRange)(context.filters, context.timeFieldName);
    if (filtersFromEvent) {
      var _params$filters;
      params.filters = [...((_params$filters = params.filters) !== null && _params$filters !== void 0 ? _params$filters : []), ...filtersFromEvent];
    }
    if (timeRangeFromEvent) {
      params.timeRange = timeRangeFromEvent;
    }
    const location = await this.locator.getLocation(params);
    if (useUrlForState) {
      this.useUrlForState(location);
    }
    return location;
  }
  useUrlForState(location) {
    var _state$filters;
    const state = location.state;
    location.path = (0, _public2.setStateToKbnUrl)('_a', (0, _public.cleanEmptyKeys)({
      query: state.query,
      filters: (_state$filters = state.filters) === null || _state$filters === void 0 ? void 0 : _state$filters.filter(f => !(0, _esQuery.isFilterPinned)(f))
    }), {
      useHash: false,
      storeInHashQuery: true
    }, location.path);
  }
}
exports.EmbeddableToDashboardDrilldown = EmbeddableToDashboardDrilldown;