"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OPEN_FLYOUT_EDIT_DRILLDOWN = exports.FlyoutEditDrilldownAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _operators = require("rxjs/operators");
var _rxjs = require("rxjs");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _public3 = require("@kbn/embeddable-enhanced-plugin/public");
var _i18n = require("./i18n");
var _menu_item = require("./menu_item");
var _drilldown_shared = require("../drilldown_shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_FLYOUT_EDIT_DRILLDOWN = 'OPEN_FLYOUT_EDIT_DRILLDOWN';
exports.OPEN_FLYOUT_EDIT_DRILLDOWN = OPEN_FLYOUT_EDIT_DRILLDOWN;
class FlyoutEditDrilldownAction {
  constructor(params) {
    (0, _defineProperty2.default)(this, "type", OPEN_FLYOUT_EDIT_DRILLDOWN);
    (0, _defineProperty2.default)(this, "id", OPEN_FLYOUT_EDIT_DRILLDOWN);
    (0, _defineProperty2.default)(this, "order", 10);
    (0, _defineProperty2.default)(this, "grouping", _public3.embeddableEnhancedDrilldownGrouping);
    (0, _defineProperty2.default)(this, "MenuItem", _menu_item.MenuItem);
    this.params = params;
  }
  getDisplayName() {
    return _i18n.txtDisplayName;
  }
  getIconType() {
    return 'list';
  }
  async isCompatible({
    embeddable
  }) {
    if (embeddable.getInput().viewMode !== _public2.ViewMode.EDIT) return false;
    if (!(0, _public3.isEnhancedEmbeddable)(embeddable)) return false;
    return embeddable.enhancements.dynamicActions.state.get().events.length > 0;
  }
  async execute(context) {
    const {
      core,
      plugins
    } = this.params.start();
    const {
      embeddable
    } = context;
    if (!(0, _public3.isEnhancedEmbeddable)(embeddable)) {
      throw new Error('Need embeddable to be EnhancedEmbeddable to execute FlyoutEditDrilldownAction.');
    }
    const templates = (0, _drilldown_shared.createDrilldownTemplatesFromSiblings)(embeddable);
    const closed$ = new _rxjs.Subject();
    const close = () => {
      closed$.next(true);
      handle.close();
    };
    const closeFlyout = () => {
      close();
    };
    const handle = core.overlays.openFlyout((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(plugins.uiActionsEnhanced.DrilldownManager, {
      initialRoute: '/manage',
      dynamicActionManager: embeddable.enhancements.dynamicActions,
      triggers: [...(0, _drilldown_shared.ensureNestedTriggers)(embeddable.supportedTriggers()), _public2.CONTEXT_MENU_TRIGGER],
      placeContext: {
        embeddable
      },
      templates: templates,
      onClose: close
    }), {
      theme$: core.theme.theme$
    }), {
      ownFocus: true,
      'data-test-subj': 'editDrilldownFlyout'
    });

    // Close flyout on application change.
    core.application.currentAppId$.pipe((0, _operators.takeUntil)(closed$), (0, _operators.skip)(1), (0, _operators.take)(1)).subscribe(closeFlyout);

    // Close flyout on dashboard switch to "view" mode or on embeddable destroy.
    embeddable.getInput$().pipe((0, _operators.takeUntil)(closed$), (0, _operators.map)(input => input.viewMode), (0, _operators.distinctUntilChanged)(), (0, _operators.filter)(mode => mode !== _public2.ViewMode.EDIT), (0, _operators.take)(1)).subscribe({
      next: closeFlyout,
      complete: closeFlyout
    });
  }
}
exports.FlyoutEditDrilldownAction = FlyoutEditDrilldownAction;