"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomIntegrationsServicesProvider = void 0;
exports.useCustomIntegrationsServices = useCustomIntegrationsServices;
exports.usePlatformService = exports.useFindService = void 0;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// The React Context used to provide the services to the CustomIntegrations components.
const CustomIntegrationsServicesContext = /*#__PURE__*/(0, _react.createContext)(null);

/**
 * The `React.Context` Provider component for the `CustomIntegrationsServices` context.  Any
 * plugin or environment that consumes CustomIntegrationsServices components needs to wrap their React
 * tree with this provider.
 *
 * Within a plugin, you can  use the CustomIntegrations plugin and retrieve a fully-configured
 * context from the `start` contract.
 */
const CustomIntegrationsServicesProvider = ({
  children,
  ...services
}) => /*#__PURE__*/_react.default.createElement(CustomIntegrationsServicesContext.Provider, {
  value: services
}, children);

/**
 * React hook for accessing pre-wired `SharedUxServices`.
 */
exports.CustomIntegrationsServicesProvider = CustomIntegrationsServicesProvider;
function useCustomIntegrationsServices() {
  const context = (0, _react.useContext)(CustomIntegrationsServicesContext);
  if (!context) {
    throw new Error('CustomIntegrationsServicesContext missing.  Ensure your component or React root is wrapped with CustomIntegrationsServicesProvider.');
  }
  return context;
}

/**
 * A React hook that provides connections to the `CustomIntegrationsFindService`.
 */
const useFindService = () => useCustomIntegrationsServices().find;

/**
 * A React hook that provides connections to the `CustomIntegrationsPlatformService`.
 */
exports.useFindService = useFindService;
const usePlatformService = () => useCustomIntegrationsServices().platform;
exports.usePlatformService = usePlatformService;