"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setApiError = exports.sendApiRequest = exports.clearApiError = exports.apiRequestStart = exports.apiRequestEnd = void 0;
var t = _interopRequireWildcard(require("../action_types"));
var _constants = require("../../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apiRequestStart = ({
  label,
  scope,
  status = _constants.API_STATUS.LOADING
}) => ({
  type: t.API_REQUEST_START,
  payload: {
    label,
    scope,
    status
  }
});
exports.apiRequestStart = apiRequestStart;
const apiRequestEnd = ({
  label,
  scope
}) => ({
  type: t.API_REQUEST_END,
  payload: {
    label,
    scope
  }
});
exports.apiRequestEnd = apiRequestEnd;
const setApiError = ({
  error,
  scope
}) => ({
  type: t.API_ERROR_SET,
  payload: {
    error,
    scope
  }
});
exports.setApiError = setApiError;
const clearApiError = scope => ({
  type: t.API_ERROR_SET,
  payload: {
    error: null,
    scope
  }
});
exports.clearApiError = clearApiError;
const sendApiRequest = ({
  label,
  scope,
  status,
  handler,
  onSuccess = () => undefined,
  onError = () => undefined
}) => async (dispatch, getState) => {
  dispatch(clearApiError(scope));
  dispatch(apiRequestStart({
    label,
    scope,
    status
  }));
  try {
    const response = await handler(dispatch);
    dispatch(apiRequestEnd({
      label,
      scope
    }));
    dispatch({
      type: `${label}_SUCCESS`,
      payload: response
    });
    onSuccess(response, dispatch, getState);
  } catch (error) {
    dispatch(apiRequestEnd({
      label,
      scope
    }));
    dispatch(setApiError({
      error,
      scope
    }));
    dispatch({
      type: `${label}_FAILURE`,
      payload: error
    });
    onError(error, dispatch, getState);
  }
};
exports.sendApiRequest = sendApiRequest;