"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resumeFollowerIndex = exports.resumeAutoFollowPattern = exports.pauseFollowerIndex = exports.pauseAutoFollowPattern = exports.loadRemoteClusters = exports.loadPermissions = exports.loadIndices = exports.loadFollowerIndices = exports.loadAutoFollowStats = exports.loadAutoFollowPatterns = exports.getHttpClient = exports.getFollowerIndex = exports.getAutoFollowPattern = exports.deleteAutoFollowPattern = exports.createFollowerIndex = exports.createAutoFollowPattern = void 0;
exports.setHttpClient = setHttpClient;
exports.updateFollowerIndex = exports.updateAutoFollowPattern = exports.unfollowLeaderIndex = void 0;
var _constants = require("../../../common/constants");
var _utils = require("../../../common/services/utils");
var _constants2 = require("../constants");
var _track_ui_metric = require("./track_ui_metric");
var _follower_index_default_settings = require("./follower_index_default_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

let httpClient;
function setHttpClient(client) {
  httpClient = client;
}
const getHttpClient = () => {
  return httpClient;
};

// ---
exports.getHttpClient = getHttpClient;
const createIdString = ids => ids.map(id => encodeURIComponent(id)).join(',');

/* Auto Follow Pattern */
const loadAutoFollowPatterns = asSystemRequest => httpClient.get(`${_constants.API_BASE_PATH}/auto_follow_patterns`, {
  asSystemRequest
});
exports.loadAutoFollowPatterns = loadAutoFollowPatterns;
const getAutoFollowPattern = id => httpClient.get(`${_constants.API_BASE_PATH}/auto_follow_patterns/${encodeURIComponent(id)}`);
exports.getAutoFollowPattern = getAutoFollowPattern;
const loadRemoteClusters = () => httpClient.get(_constants.API_REMOTE_CLUSTERS_BASE_PATH);
exports.loadRemoteClusters = loadRemoteClusters;
const createAutoFollowPattern = autoFollowPattern => {
  const request = httpClient.post(`${_constants.API_BASE_PATH}/auto_follow_patterns`, {
    body: JSON.stringify(autoFollowPattern)
  });
  return (0, _track_ui_metric.trackUserRequest)(request, _constants2.UIM_AUTO_FOLLOW_PATTERN_CREATE);
};
exports.createAutoFollowPattern = createAutoFollowPattern;
const updateAutoFollowPattern = (id, autoFollowPattern) => {
  const request = httpClient.put(`${_constants.API_BASE_PATH}/auto_follow_patterns/${encodeURIComponent(id)}`, {
    body: JSON.stringify(autoFollowPattern)
  });
  return (0, _track_ui_metric.trackUserRequest)(request, _constants2.UIM_AUTO_FOLLOW_PATTERN_UPDATE);
};
exports.updateAutoFollowPattern = updateAutoFollowPattern;
const deleteAutoFollowPattern = id => {
  const ids = (0, _utils.arrify)(id);
  const idString = ids.map(_id => encodeURIComponent(_id)).join(',');
  const request = httpClient.delete(`${_constants.API_BASE_PATH}/auto_follow_patterns/${idString}`);
  const uiMetric = ids.length > 1 ? _constants2.UIM_AUTO_FOLLOW_PATTERN_DELETE_MANY : _constants2.UIM_AUTO_FOLLOW_PATTERN_DELETE;
  return (0, _track_ui_metric.trackUserRequest)(request, uiMetric);
};
exports.deleteAutoFollowPattern = deleteAutoFollowPattern;
const pauseAutoFollowPattern = id => {
  const ids = (0, _utils.arrify)(id);
  const idString = ids.map(encodeURIComponent).join(',');
  const request = httpClient.post(`${_constants.API_BASE_PATH}/auto_follow_patterns/${idString}/pause`);
  const uiMetric = ids.length > 1 ? _constants2.UIM_AUTO_FOLLOW_PATTERN_PAUSE_MANY : _constants2.UIM_AUTO_FOLLOW_PATTERN_PAUSE;
  return (0, _track_ui_metric.trackUserRequest)(request, uiMetric);
};
exports.pauseAutoFollowPattern = pauseAutoFollowPattern;
const resumeAutoFollowPattern = id => {
  const ids = (0, _utils.arrify)(id);
  const idString = ids.map(encodeURIComponent).join(',');
  const request = httpClient.post(`${_constants.API_BASE_PATH}/auto_follow_patterns/${idString}/resume`);
  const uiMetric = ids.length > 1 ? _constants2.UIM_AUTO_FOLLOW_PATTERN_RESUME_MANY : _constants2.UIM_AUTO_FOLLOW_PATTERN_RESUME;
  return (0, _track_ui_metric.trackUserRequest)(request, uiMetric);
};

/* Follower Index */
exports.resumeAutoFollowPattern = resumeAutoFollowPattern;
const loadFollowerIndices = asSystemRequest => httpClient.get(`${_constants.API_BASE_PATH}/follower_indices`, {
  asSystemRequest
});
exports.loadFollowerIndices = loadFollowerIndices;
const getFollowerIndex = id => httpClient.get(`${_constants.API_BASE_PATH}/follower_indices/${encodeURIComponent(id)}`);
exports.getFollowerIndex = getFollowerIndex;
const createFollowerIndex = followerIndex => {
  const uiMetrics = [_constants2.UIM_FOLLOWER_INDEX_CREATE];
  const isUsingAdvancedSettings = !(0, _follower_index_default_settings.areAllSettingsDefault)(followerIndex);
  if (isUsingAdvancedSettings) {
    uiMetrics.push(_constants2.UIM_FOLLOWER_INDEX_USE_ADVANCED_OPTIONS);
  }
  const request = httpClient.post(`${_constants.API_BASE_PATH}/follower_indices`, {
    body: JSON.stringify(followerIndex)
  });
  return (0, _track_ui_metric.trackUserRequest)(request, uiMetrics);
};
exports.createFollowerIndex = createFollowerIndex;
const pauseFollowerIndex = id => {
  const ids = (0, _utils.arrify)(id);
  const idString = createIdString(ids);
  const request = httpClient.put(`${_constants.API_BASE_PATH}/follower_indices/${idString}/pause`);
  const uiMetric = ids.length > 1 ? _constants2.UIM_FOLLOWER_INDEX_PAUSE_MANY : _constants2.UIM_FOLLOWER_INDEX_PAUSE;
  return (0, _track_ui_metric.trackUserRequest)(request, uiMetric);
};
exports.pauseFollowerIndex = pauseFollowerIndex;
const resumeFollowerIndex = id => {
  const ids = (0, _utils.arrify)(id);
  const idString = createIdString(ids);
  const request = httpClient.put(`${_constants.API_BASE_PATH}/follower_indices/${idString}/resume`);
  const uiMetric = ids.length > 1 ? _constants2.UIM_FOLLOWER_INDEX_RESUME_MANY : _constants2.UIM_FOLLOWER_INDEX_RESUME;
  return (0, _track_ui_metric.trackUserRequest)(request, uiMetric);
};
exports.resumeFollowerIndex = resumeFollowerIndex;
const unfollowLeaderIndex = id => {
  const ids = (0, _utils.arrify)(id);
  const idString = createIdString(ids);
  const request = httpClient.put(`${_constants.API_BASE_PATH}/follower_indices/${idString}/unfollow`);
  const uiMetric = ids.length > 1 ? _constants2.UIM_FOLLOWER_INDEX_UNFOLLOW_MANY : _constants2.UIM_FOLLOWER_INDEX_UNFOLLOW;
  return (0, _track_ui_metric.trackUserRequest)(request, uiMetric);
};
exports.unfollowLeaderIndex = unfollowLeaderIndex;
const updateFollowerIndex = (id, followerIndex) => {
  const uiMetrics = [_constants2.UIM_FOLLOWER_INDEX_UPDATE];
  const isUsingAdvancedSettings = !(0, _follower_index_default_settings.areAllSettingsDefault)(followerIndex);
  if (isUsingAdvancedSettings) {
    uiMetrics.push(_constants2.UIM_FOLLOWER_INDEX_USE_ADVANCED_OPTIONS);
  }
  const {
    maxReadRequestOperationCount,
    maxOutstandingReadRequests,
    maxReadRequestSize,
    maxWriteRequestOperationCount,
    maxWriteRequestSize,
    maxOutstandingWriteRequests,
    maxWriteBufferCount,
    maxWriteBufferSize,
    maxRetryDelay,
    readPollTimeout
  } = followerIndex;
  const request = httpClient.put(`${_constants.API_BASE_PATH}/follower_indices/${encodeURIComponent(id)}`, {
    body: JSON.stringify({
      maxReadRequestOperationCount,
      maxOutstandingReadRequests,
      maxReadRequestSize,
      maxWriteRequestOperationCount,
      maxWriteRequestSize,
      maxOutstandingWriteRequests,
      maxWriteBufferCount,
      maxWriteBufferSize,
      maxRetryDelay,
      readPollTimeout
    })
  });
  return (0, _track_ui_metric.trackUserRequest)(request, uiMetrics);
};

/* Stats */
exports.updateFollowerIndex = updateFollowerIndex;
const loadAutoFollowStats = () => httpClient.get(`${_constants.API_BASE_PATH}/stats/auto_follow`);

/* Indices */
exports.loadAutoFollowStats = loadAutoFollowStats;
let abortController = null;
const loadIndices = () => {
  if (abortController) {
    abortController.abort();
    abortController = null;
  }
  abortController = new AbortController();
  const {
    signal
  } = abortController;
  return httpClient.get(`${_constants.API_INDEX_MANAGEMENT_BASE_PATH}/indices`, {
    signal
  }).then(response => {
    abortController = null;
    return response;
  });
};
exports.loadIndices = loadIndices;
const loadPermissions = () => httpClient.get(`${_constants.API_BASE_PATH}/permissions`);
exports.loadPermissions = loadPermissions;