"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextMenu = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _routing = require("../../../../../services/routing");
var _components = require("../../../../../components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ContextMenu extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "editFollowerIndex", id => {
      const uri = _routing.routing.getFollowerIndexPath(id);
      _routing.routing.navigate(uri);
    });
  }
  render() {
    const {
      followerIndices
    } = this.props;
    const followerIndicesLength = followerIndices.length;
    const followerIndexNames = followerIndices.map(index => index.name);
    const {
      iconSide = 'right',
      iconType = 'arrowDown',
      anchorPosition = 'rightUp',
      label = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndex.contextMenu.buttonLabel",
        defaultMessage: "Manage follower {followerIndicesLength, plural, one {index} other {indices}}",
        values: {
          followerIndicesLength
        }
      }),
      testSubj
    } = this.props;
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": testSubj,
      iconSide: iconSide,
      onClick: this.onButtonClick,
      iconType: iconType,
      fill: true
    }, label);
    const pausedFollowerIndexNames = followerIndices.filter(({
      isPaused
    }) => isPaused).map(index => index.name);
    const activeFollowerIndices = followerIndices.filter(({
      isPaused
    }) => !isPaused);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      anchorPosition: anchorPosition,
      repositionOnScroll: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      paddingSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndex.contextMenu.title",
      defaultMessage: "Follower {followerIndicesLength, plural, one {index} other {indices}} options",
      values: {
        followerIndicesLength
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      "data-test-subj": "contextMenu"
    }, activeFollowerIndices.length ? /*#__PURE__*/_react.default.createElement(_components.FollowerIndexPauseProvider, {
      onConfirm: this.closePopover
    }, pauseFollowerIndex => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "pause",
      onClick: () => pauseFollowerIndex(activeFollowerIndices),
      "data-test-subj": "pauseButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndex.contextMenu.pauseLabel",
      defaultMessage: "Pause replication"
    }))) : null, pausedFollowerIndexNames.length ? /*#__PURE__*/_react.default.createElement(_components.FollowerIndexResumeProvider, {
      onConfirm: this.closePopover
    }, resumeFollowerIndex => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "play",
      onClick: () => resumeFollowerIndex(pausedFollowerIndexNames),
      "data-test-subj": "resumeButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndex.contextMenu.resumeLabel",
      defaultMessage: "Resume replication"
    }))) : null, followerIndexNames.length === 1 && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "pencil",
      onClick: () => this.editFollowerIndex(followerIndexNames[0]),
      "data-test-subj": "editButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndex.contextMenu.editLabel",
      "data-test-subj": "editButton",
      defaultMessage: "Edit follower index"
    }))), /*#__PURE__*/_react.default.createElement(_components.FollowerIndexUnfollowProvider, {
      onConfirm: this.closePopover
    }, unfollowLeaderIndex => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "indexFlush",
      onClick: () => unfollowLeaderIndex(followerIndexNames),
      "data-test-subj": "unfollowButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndex.contextMenu.unfollowLabel",
      defaultMessage: "Unfollow leader {followerIndicesLength, plural, one {index} other {indices}}",
      values: {
        followerIndicesLength
      }
    })))));
  }
}
exports.ContextMenu = ContextMenu;
(0, _defineProperty2.default)(ContextMenu, "propTypes", {
  iconSide: _propTypes.default.string,
  iconType: _propTypes.default.string,
  anchorPosition: _propTypes.default.string,
  label: _propTypes.default.node,
  followerIndices: _propTypes.default.array.isRequired
});