"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserSettingsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @internal
 */

class UserSettingsService {
  constructor(coreContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "client", void 0);
    this.logger = coreContext.logger.get('user-settings-service');
  }
  setup() {
    return {
      setUserProfileSettings: client => {
        this.client = client;
      },
      getUserSettingDarkMode: async request => {
        const userSettings = await this.getSettings(request);
        return this.getUserSettingDarkMode(userSettings);
      }
    };
  }
  async getSettings(request) {
    let result = {};
    if (this.client) {
      result = await this.client.get(request);
    } else {
      this.logger.debug('UserProfileSettingsClient not set');
    }
    return result;
  }
  async getUserSettingDarkMode(userSettings) {
    let result;
    if (userSettings !== null && userSettings !== void 0 && userSettings.darkMode) {
      result = userSettings.darkMode.toUpperCase() === 'DARK';
    }
    return result;
  }
}
exports.UserSettingsService = UserSettingsService;