"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOutdatedDocumentsQuery = void 0;
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getOutdatedDocumentsQuery = ({
  types
}) => {
  // Note: in theory, we could check the difference of model version with the index's
  // and narrow the search filter only on the type that have different versions.
  // however, it feels safer to just search for all outdated document, just in case.
  const modelVersions = (0, _coreSavedObjectsBaseServerInternal.getModelVersionMapForTypes)(types);
  return {
    bool: {
      should: types.map(type => {
        const virtualVersion = (0, _coreSavedObjectsBaseServerInternal.modelVersionToVirtualVersion)(modelVersions[type.name]);
        return {
          bool: {
            must: [{
              term: {
                type: type.name
              }
            }, {
              bool: {
                should: [{
                  bool: {
                    must: {
                      exists: {
                        field: 'migrationVersion'
                      }
                    },
                    must_not: {
                      term: {
                        [`migrationVersion.${type.name}`]: virtualVersion
                      }
                    }
                  }
                }, {
                  bool: {
                    must_not: [{
                      exists: {
                        field: 'migrationVersion'
                      }
                    }, {
                      term: {
                        typeMigrationVersion: virtualVersion
                      }
                    }]
                  }
                }]
              }
            }]
          }
        };
      })
    }
  };
};
exports.getOutdatedDocumentsQuery = getOutdatedDocumentsQuery;