"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTargetIndex = void 0;
var _lodash = require("lodash");
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _retry_state = require("../../../model/retry_state");
var _helpers = require("../../../model/helpers");
var _constants = require("../../../common/constants");
var _actions = require("../../actions");
var _utils = require("../../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createTargetIndex = (state, res, context) => {
  if (Either.isLeft(res)) {
    const left = res.left;
    if ((0, _actions.isTypeof)(left, 'index_not_green_timeout')) {
      // cluster might just be busy so we retry the action for a set number of times.
      const retryErrorMessage = `${left.message} Refer to ${context.migrationDocLinks.repeatedTimeoutRequests} for information on how to resolve the issue.`;
      return (0, _retry_state.delayRetryState)(state, retryErrorMessage, context.maxRetryAttempts);
    } else if ((0, _actions.isTypeof)(left, 'cluster_shard_limit_exceeded')) {
      return {
        ...state,
        controlState: 'FATAL',
        reason: `${_constants.CLUSTER_SHARD_LIMIT_EXCEEDED_REASON} See ${context.migrationDocLinks.clusterShardLimitExceeded}`
      };
    } else {
      return (0, _helpers.throwBadResponse)(state, left);
    }
  }
  const aliasActions = (0, _utils.getAliasActions)({
    currentIndex: state.currentIndex,
    existingAliases: [],
    indexPrefix: context.indexPrefix,
    kibanaVersion: context.kibanaVersion
  });
  const currentIndexMeta = (0, _lodash.cloneDeep)(state.indexMappings._meta);
  return {
    ...state,
    controlState: aliasActions.length ? 'UPDATE_ALIASES' : 'INDEX_STATE_UPDATE_DONE',
    previousMappings: state.indexMappings,
    currentIndexMeta,
    aliases: [],
    aliasActions,
    newIndexCreation: true
  };
};
exports.createTargetIndex = createTargetIndex;