"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInitialState = void 0;
var Option = _interopRequireWildcard(require("fp-ts/Option"));
var _core = require("./core");
var _helpers = require("./model/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Construct the initial state for the model
 */
const createInitialState = ({
  kibanaVersion,
  waitForMigrationCompletion,
  mustRelocateDocuments,
  indexTypesMap,
  targetMappings,
  preMigrationScript,
  migrationVersionPerType,
  indexPrefix,
  migrationsConfig,
  typeRegistry,
  docLinks,
  logger
}) => {
  const outdatedDocumentsQuery = {
    bool: {
      should: Object.entries(migrationVersionPerType).map(([type, latestVersion]) => ({
        bool: {
          must: [{
            term: {
              type
            }
          }, {
            bool: {
              should: [{
                bool: {
                  must: {
                    exists: {
                      field: 'migrationVersion'
                    }
                  },
                  must_not: {
                    term: {
                      [`migrationVersion.${type}`]: latestVersion
                    }
                  }
                }
              }, {
                bool: {
                  must_not: [{
                    exists: {
                      field: 'migrationVersion'
                    }
                  }, {
                    term: {
                      typeMigrationVersion: latestVersion
                    }
                  }]
                }
              }]
            }
          }]
        }
      }))
    }
  };
  const reindexTargetMappings = {
    dynamic: false,
    properties: {
      type: {
        type: 'keyword'
      },
      typeMigrationVersion: {
        type: 'version'
      }
    }
  };
  const knownTypes = typeRegistry.getAllTypes().map(type => type.name);
  const excludeFilterHooks = Object.fromEntries(typeRegistry.getAllTypes().filter(type => !!type.excludeOnUpgrade).map(type => [type.name, type.excludeOnUpgrade]));
  // short key to access savedObjects entries directly from docLinks
  const migrationDocLinks = docLinks.links.kibanaUpgradeSavedObjects;
  if (migrationsConfig.discardUnknownObjects && migrationsConfig.discardUnknownObjects !== kibanaVersion) {
    logger.warn('The flag `migrations.discardUnknownObjects` is defined but does not match the current kibana version; unknown objects will NOT be discarded.');
  }
  if (migrationsConfig.discardCorruptObjects && migrationsConfig.discardCorruptObjects !== kibanaVersion) {
    logger.warn('The flag `migrations.discardCorruptObjects` is defined but does not match the current kibana version; corrupt objects will NOT be discarded.');
  }
  const targetIndexMappings = {
    ...targetMappings,
    _meta: {
      ...targetMappings._meta,
      indexTypesMap
    }
  };
  return {
    controlState: 'INIT',
    waitForMigrationCompletion,
    mustRelocateDocuments,
    indexTypesMap,
    indexPrefix,
    legacyIndex: indexPrefix,
    currentAlias: indexPrefix,
    versionAlias: `${indexPrefix}_${kibanaVersion}`,
    versionIndex: `${indexPrefix}_${kibanaVersion}_001`,
    tempIndex: (0, _helpers.getTempIndexName)(indexPrefix, kibanaVersion),
    tempIndexAlias: (0, _helpers.getTempIndexName)(indexPrefix, kibanaVersion) + '_alias',
    kibanaVersion,
    preMigrationScript: Option.fromNullable(preMigrationScript),
    targetIndexMappings,
    tempIndexMappings: reindexTargetMappings,
    outdatedDocumentsQuery,
    retryCount: 0,
    retryDelay: 0,
    retryAttempts: migrationsConfig.retryAttempts,
    batchSize: migrationsConfig.batchSize,
    maxBatchSize: migrationsConfig.batchSize,
    maxBatchSizeBytes: migrationsConfig.maxBatchSizeBytes.getValueInBytes(),
    maxReadBatchSizeBytes: migrationsConfig.maxReadBatchSizeBytes.getValueInBytes(),
    discardUnknownObjects: migrationsConfig.discardUnknownObjects === kibanaVersion,
    discardCorruptObjects: migrationsConfig.discardCorruptObjects === kibanaVersion,
    logs: [],
    excludeOnUpgradeQuery: _core.excludeUnusedTypesQuery,
    knownTypes,
    excludeFromUpgradeFilterHooks: excludeFilterHooks,
    migrationDocLinks
  };
};
exports.createInitialState = createInitialState;