"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModelVersionTransforms = exports.convertModelVersionTransformFn = void 0;
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
var _core = require("../core");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const noopTransform = doc => ({
  transformedDoc: doc,
  additionalDocs: []
});
const getModelVersionTransforms = ({
  typeDefinition,
  log
}) => {
  var _typeDefinition$model;
  const modelVersionMap = typeof typeDefinition.modelVersions === 'function' ? typeDefinition.modelVersions() : (_typeDefinition$model = typeDefinition.modelVersions) !== null && _typeDefinition$model !== void 0 ? _typeDefinition$model : {};
  return Object.entries(modelVersionMap).map(([rawModelVersion, definition]) => {
    const modelVersion = (0, _coreSavedObjectsBaseServerInternal.assertValidModelVersion)(rawModelVersion);
    const virtualVersion = (0, _coreSavedObjectsBaseServerInternal.modelVersionToVirtualVersion)(modelVersion);
    return {
      version: virtualVersion,
      transform: convertModelVersionTransformFn({
        log,
        modelVersion,
        virtualVersion,
        definition,
        type: 'up'
      }),
      transformDown: convertModelVersionTransformFn({
        log,
        modelVersion,
        virtualVersion,
        definition,
        type: 'down'
      }),
      transformType: _types.TransformType.Migrate
    };
  });
};
exports.getModelVersionTransforms = getModelVersionTransforms;
const convertModelVersionTransformFn = ({
  virtualVersion,
  modelVersion,
  definition,
  type,
  log
}) => {
  if (!definition.modelChange.transformation) {
    return noopTransform;
  }
  const context = {
    log,
    modelVersion
  };
  const modelTransformFn = type === 'up' ? definition.modelChange.transformation.up : definition.modelChange.transformation.down;
  return function convertedTransform(doc) {
    try {
      const result = modelTransformFn(doc, context);
      return {
        transformedDoc: result.document,
        additionalDocs: []
      };
    } catch (error) {
      log.error(error);
      throw new _core.TransformSavedObjectDocumentError(error, virtualVersion);
    }
  };
};
exports.convertModelVersionTransformFn = convertModelVersionTransformFn;