"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildActiveMigrations = buildActiveMigrations;
var _lodash = _interopRequireDefault(require("lodash"));
var _types = require("./types");
var _internal_transforms = require("./internal_transforms");
var _validate_migrations = require("./validate_migrations");
var _utils = require("./utils");
var _model_version = require("./model_version");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Converts migrations from a format that is convenient for callers to a format that
 * is convenient for our internal usage:
 * From: { type: { version: fn } }
 * To:   { type: { latestVersion?: Record<TransformType, string>; transforms: [{ version: string, transform: fn }] } }
 */
function buildActiveMigrations({
  typeRegistry,
  kibanaVersion,
  convertVersion,
  log
}) {
  const coreTransforms = (0, _internal_transforms.getCoreTransforms)();
  const referenceTransforms = (0, _internal_transforms.getReferenceTransforms)(typeRegistry);
  return typeRegistry.getAllTypes().reduce((migrations, type) => {
    (0, _validate_migrations.validateTypeMigrations)({
      type,
      kibanaVersion,
      convertVersion
    });
    const typeTransforms = buildTypeTransforms({
      type,
      log,
      kibanaVersion,
      coreTransforms,
      referenceTransforms
    });
    if (!typeTransforms.transforms.length) {
      return migrations;
    }
    return {
      ...migrations,
      [type.name]: typeTransforms
    };
  }, {});
}
const buildTypeTransforms = ({
  type,
  log,
  coreTransforms,
  referenceTransforms
}) => {
  var _type$migrations;
  const migrationsMap = typeof type.migrations === 'function' ? type.migrations() : (_type$migrations = type.migrations) !== null && _type$migrations !== void 0 ? _type$migrations : {};
  const migrationTransforms = Object.entries(migrationsMap !== null && migrationsMap !== void 0 ? migrationsMap : {}).map(([version, transform]) => ({
    version,
    transform: (0, _utils.convertMigrationFunction)(version, type, transform, log),
    transformType: _types.TransformType.Migrate
  }));
  const modelVersionTransforms = (0, _model_version.getModelVersionTransforms)({
    log,
    typeDefinition: type
  });
  const conversionTransforms = (0, _internal_transforms.getConversionTransforms)(type);
  const transforms = [...coreTransforms, ...referenceTransforms, ...conversionTransforms, ...migrationTransforms, ...modelVersionTransforms].sort(_utils.transformComparator);
  return {
    latestVersion: _lodash.default.chain(transforms).groupBy('transformType').mapValues(items => {
      var _$last;
      return (_$last = _lodash.default.last(items)) === null || _$last === void 0 ? void 0 : _$last.version;
    }).value(),
    transforms
  };
};