"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logStateTransition = exports.logActionResponse = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const logStateTransition = (logger, logMessagePrefix, prevState, currState, tookMs) => {
  if (currState.logs.length > prevState.logs.length) {
    currState.logs.slice(prevState.logs.length).forEach(({
      message,
      level
    }) => {
      switch (level) {
        case 'error':
          return logger.error(logMessagePrefix + message);
        case 'warning':
          return logger.warn(logMessagePrefix + message);
        case 'info':
          return logger.info(logMessagePrefix + message);
        default:
          throw new Error(`unexpected log level ${level}`);
      }
    });
  }
  logger.info(logMessagePrefix + `${prevState.controlState} -> ${currState.controlState}. took: ${tookMs}ms.`);
  logger.debug(logMessagePrefix + `${prevState.controlState} -> ${currState.controlState}. took: ${tookMs}ms.`, {
    kibana: {
      migrations: {
        state: currState,
        duration: tookMs
      }
    }
  });
};
exports.logStateTransition = logStateTransition;
const logActionResponse = (logger, logMessagePrefix, state, res) => {
  logger.debug(logMessagePrefix + `${state.controlState} RESPONSE`, res);
};
exports.logActionResponse = logActionResponse;