"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsTypeValidator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _semver = _interopRequireDefault(require("semver"));
var _schema = require("./schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Helper class that takes a {@link SavedObjectsValidationMap} and runs validations for a
 * given type based on the provided Kibana version.
 *
 * @internal
 */
class SavedObjectsTypeValidator {
  constructor({
    logger,
    type,
    validationMap,
    defaultVersion
  }) {
    (0, _defineProperty2.default)(this, "log", void 0);
    (0, _defineProperty2.default)(this, "type", void 0);
    (0, _defineProperty2.default)(this, "defaultVersion", void 0);
    (0, _defineProperty2.default)(this, "validationMap", void 0);
    (0, _defineProperty2.default)(this, "orderedVersions", void 0);
    this.log = logger;
    this.type = type;
    this.defaultVersion = defaultVersion;
    this.validationMap = typeof validationMap === 'function' ? validationMap() : validationMap;
    this.orderedVersions = Object.keys(this.validationMap).sort(_semver.default.compare);
  }
  validate(document, version) {
    var _ref, _ref2, _document$migrationVe;
    const docVersion = (_ref = (_ref2 = version !== null && version !== void 0 ? version : document.typeMigrationVersion) !== null && _ref2 !== void 0 ? _ref2 : (_document$migrationVe = document.migrationVersion) === null || _document$migrationVe === void 0 ? void 0 : _document$migrationVe[document.type]) !== null && _ref !== void 0 ? _ref : this.defaultVersion;
    const schemaVersion = previousVersionWithSchema(this.orderedVersions, docVersion);
    if (!schemaVersion || !this.validationMap[schemaVersion]) {
      return;
    }
    const validationRule = this.validationMap[schemaVersion];
    try {
      const validationSchema = (0, _schema.createSavedObjectSanitizedDocSchema)(validationRule);
      validationSchema.validate(document);
    } catch (e) {
      this.log.warn(`Error validating object of type [${this.type}] against version [${docVersion}]`);
      throw e;
    }
  }
}
exports.SavedObjectsTypeValidator = SavedObjectsTypeValidator;
const previousVersionWithSchema = (orderedVersions, targetVersion) => {
  for (let i = orderedVersions.length - 1; i >= 0; i--) {
    const currentVersion = orderedVersions[i];
    if (_semver.default.lte(currentVersion, targetVersion)) {
      return currentVersion;
    }
  }
  return undefined;
};