"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getObjectKey = getObjectKey;
exports.parseObjectKey = parseObjectKey;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Takes an object with a `type` and `id` field and returns a key string.
 *
 * @internal
 */
function getObjectKey({
  type,
  id
}) {
  return `${type}:${id}`;
}

/**
 * Parses a 'type:id' key string and returns an object with a `type` field and an `id` field.
 *
 * @internal
 */
function parseObjectKey(key) {
  const type = key.slice(0, key.indexOf(':'));
  const id = key.slice(type.length + 1);
  if (!type || !id) {
    throw new Error('Malformed object key (should be "type:id")');
  }
  return {
    type,
    id
  };
}