"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModelVersionMapForTypes = exports.getLatestModelVersion = void 0;
var _conversion = require("./conversion");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Returns the latest registered model version number for the given type.
 */
const getLatestModelVersion = type => {
  var _type$modelVersions;
  const versionMap = typeof type.modelVersions === 'function' ? type.modelVersions() : (_type$modelVersions = type.modelVersions) !== null && _type$modelVersions !== void 0 ? _type$modelVersions : {};
  return Object.keys(versionMap).reduce((memo, current) => {
    return Math.max(memo, (0, _conversion.assertValidModelVersion)(current));
  }, 0);
};

/**
 * Build a version map for the given types.
 */
exports.getLatestModelVersion = getLatestModelVersion;
const getModelVersionMapForTypes = types => {
  return types.reduce((versionMap, type) => {
    versionMap[type.name] = getLatestModelVersion(type);
    return versionMap;
  }, {});
};
exports.getModelVersionMapForTypes = getModelVersionMapForTypes;