"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModelVersionsFromMappings = exports.getModelVersionsFromMappingMeta = void 0;
var _conversion = require("./conversion");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Build the version map from the specified source of the provided mappings.
 */
const getModelVersionsFromMappings = ({
  mappings,
  source,
  knownTypes
}) => {
  if (!mappings._meta) {
    return undefined;
  }
  return getModelVersionsFromMappingMeta({
    meta: mappings._meta,
    source,
    knownTypes
  });
};
exports.getModelVersionsFromMappings = getModelVersionsFromMappings;
/**
 * Build the version map from the specified source of the provided mappings meta.
 */
const getModelVersionsFromMappingMeta = ({
  meta,
  source,
  knownTypes
}) => {
  const indexVersions = source === 'mappingVersions' ? meta.mappingVersions : meta.docVersions;
  if (!indexVersions) {
    return undefined;
  }
  const typeSet = knownTypes ? new Set(knownTypes) : undefined;
  return Object.entries(indexVersions).reduce((map, [type, rawVersion]) => {
    if (!typeSet || typeSet.has(type)) {
      map[type] = (0, _conversion.assertValidModelVersion)(rawVersion);
    }
    return map;
  }, {});
};
exports.getModelVersionsFromMappingMeta = getModelVersionsFromMappingMeta;