"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsClientProvider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Provider for the Scoped Saved Objects Client.
 *
 * @internal
 */
class SavedObjectsClientProvider {
  constructor({
    defaultClientFactory,
    typeRegistry,
    encryptionExtensionFactory,
    securityExtensionFactory,
    spacesExtensionFactory
  }) {
    (0, _defineProperty2.default)(this, "_clientFactory", void 0);
    (0, _defineProperty2.default)(this, "_originalClientFactory", void 0);
    (0, _defineProperty2.default)(this, "encryptionExtensionFactory", void 0);
    (0, _defineProperty2.default)(this, "securityExtensionFactory", void 0);
    (0, _defineProperty2.default)(this, "spacesExtensionFactory", void 0);
    (0, _defineProperty2.default)(this, "_typeRegistry", void 0);
    this._originalClientFactory = this._clientFactory = defaultClientFactory;
    this._typeRegistry = typeRegistry;
    this.encryptionExtensionFactory = encryptionExtensionFactory;
    this.securityExtensionFactory = securityExtensionFactory;
    this.spacesExtensionFactory = spacesExtensionFactory;
  }
  setClientFactory(customClientFactory) {
    if (this._clientFactory !== this._originalClientFactory) {
      throw new Error(`custom client factory is already set, unable to replace the current one`);
    }
    this._clientFactory = customClientFactory;
  }
  getClient(request, {
    includedHiddenTypes,
    excludedExtensions = []
  } = {}) {
    return this._clientFactory({
      request,
      includedHiddenTypes,
      extensions: this.getExtensions(request, excludedExtensions)
    });
  }
  getExtensions(request, excludedExtensions) {
    const createExt = (extensionId, extensionFactory) => !excludedExtensions.includes(extensionId) && !!extensionFactory ? extensionFactory === null || extensionFactory === void 0 ? void 0 : extensionFactory({
      typeRegistry: this._typeRegistry,
      request
    }) : undefined;
    return {
      encryptionExtension: createExt(_coreSavedObjectsServer.ENCRYPTION_EXTENSION_ID, this.encryptionExtensionFactory),
      securityExtension: createExt(_coreSavedObjectsServer.SECURITY_EXTENSION_ID, this.securityExtensionFactory),
      spacesExtension: createExt(_coreSavedObjectsServer.SPACES_EXTENSION_ID, this.spacesExtensionFactory)
    };
  }
}
exports.SavedObjectsClientProvider = SavedObjectsClientProvider;