"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Server = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classPrivateFieldGet2 = _interopRequireDefault(require("@babel/runtime/helpers/classPrivateFieldGet"));
var _classPrivateFieldSet2 = _interopRequireDefault(require("@babel/runtime/helpers/classPrivateFieldSet"));
var _elasticApmNode = _interopRequireDefault(require("elastic-apm-node"));
var _ebtTools = require("@kbn/ebt-tools");
var _coreBaseServerInternal = require("@kbn/core-base-server-internal");
var _config = require("@kbn/config");
var _coreDocLinksServerInternal = require("@kbn/core-doc-links-server-internal");
var _coreLoggingServerInternal = require("@kbn/core-logging-server-internal");
var _coreConfigServerInternal = require("@kbn/core-config-server-internal");
var _coreNodeServerInternal = require("@kbn/core-node-server-internal");
var _coreAnalyticsServerInternal = require("@kbn/core-analytics-server-internal");
var _coreEnvironmentServerInternal = require("@kbn/core-environment-server-internal");
var _coreExecutionContextServerInternal = require("@kbn/core-execution-context-server-internal");
var _corePrebootServerInternal = require("@kbn/core-preboot-server-internal");
var _coreHttpContextServerInternal = require("@kbn/core-http-context-server-internal");
var _coreHttpServerInternal = require("@kbn/core-http-server-internal");
var _coreElasticsearchServerInternal = require("@kbn/core-elasticsearch-server-internal");
var _coreMetricsServerInternal = require("@kbn/core-metrics-server-internal");
var _coreCapabilitiesServerInternal = require("@kbn/core-capabilities-server-internal");
var _coreSavedObjectsServerInternal = require("@kbn/core-saved-objects-server-internal");
var _coreI18nServerInternal = require("@kbn/core-i18n-server-internal");
var _coreDeprecationsServerInternal = require("@kbn/core-deprecations-server-internal");
var _coreUsageDataServerInternal = require("@kbn/core-usage-data-server-internal");
var _coreStatusServerInternal = require("@kbn/core-status-server-internal");
var _coreUiSettingsServerInternal = require("@kbn/core-ui-settings-server-internal");
var _coreCustomBrandingServerInternal = require("@kbn/core-custom-branding-server-internal");
var _coreUserSettingsServerInternal = require("@kbn/core-user-settings-server-internal");
var _coreHttpRequestHandlerContextServerInternal = require("@kbn/core-http-request-handler-context-server-internal");
var _coreRenderingServerInternal = require("@kbn/core-rendering-server-internal");
var _coreHttpResourcesServerInternal = require("@kbn/core-http-resources-server-internal");
var _corePluginsServerInternal = require("@kbn/core-plugins-server-internal");
var _coreAppsServerInternal = require("@kbn/core-apps-server-internal");
var _register_service_config = require("./register_service_config");
var _constants = require("./constants");
function _classPrivateFieldInitSpec(obj, privateMap, value) { _checkPrivateRedeclaration(obj, privateMap); privateMap.set(obj, value); }
function _checkPrivateRedeclaration(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
const coreId = Symbol('core');
const KIBANA_STARTED_EVENT = 'kibana_started';

/** @internal */
var _pluginsInitialized = /*#__PURE__*/new WeakMap();
class Server {
  constructor(rawConfigProvider, env, loggingSystem) {
    (0, _defineProperty2.default)(this, "configService", void 0);
    (0, _defineProperty2.default)(this, "analytics", void 0);
    (0, _defineProperty2.default)(this, "capabilities", void 0);
    (0, _defineProperty2.default)(this, "context", void 0);
    (0, _defineProperty2.default)(this, "elasticsearch", void 0);
    (0, _defineProperty2.default)(this, "http", void 0);
    (0, _defineProperty2.default)(this, "rendering", void 0);
    (0, _defineProperty2.default)(this, "log", void 0);
    (0, _defineProperty2.default)(this, "plugins", void 0);
    (0, _defineProperty2.default)(this, "savedObjects", void 0);
    (0, _defineProperty2.default)(this, "uiSettings", void 0);
    (0, _defineProperty2.default)(this, "environment", void 0);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "metrics", void 0);
    (0, _defineProperty2.default)(this, "httpResources", void 0);
    (0, _defineProperty2.default)(this, "status", void 0);
    (0, _defineProperty2.default)(this, "logging", void 0);
    (0, _defineProperty2.default)(this, "coreApp", void 0);
    (0, _defineProperty2.default)(this, "coreUsageData", void 0);
    (0, _defineProperty2.default)(this, "i18n", void 0);
    (0, _defineProperty2.default)(this, "deprecations", void 0);
    (0, _defineProperty2.default)(this, "executionContext", void 0);
    (0, _defineProperty2.default)(this, "prebootService", void 0);
    (0, _defineProperty2.default)(this, "docLinks", void 0);
    (0, _defineProperty2.default)(this, "customBranding", void 0);
    (0, _defineProperty2.default)(this, "userSettingsService", void 0);
    (0, _defineProperty2.default)(this, "savedObjectsStartPromise", void 0);
    (0, _defineProperty2.default)(this, "resolveSavedObjectsStartPromise", void 0);
    _classPrivateFieldInitSpec(this, _pluginsInitialized, {
      writable: true,
      value: void 0
    });
    (0, _defineProperty2.default)(this, "coreStart", void 0);
    (0, _defineProperty2.default)(this, "discoveredPlugins", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "nodeRoles", void 0);
    (0, _defineProperty2.default)(this, "uptimePerStep", {});
    this.env = env;
    this.loggingSystem = loggingSystem;
    const constructorStartUptime = performance.now();
    this.logger = this.loggingSystem.asLoggerFactory();
    this.log = this.logger.get('server');
    this.configService = new _config.ConfigService(rawConfigProvider, env, this.logger);
    const core = {
      coreId,
      configService: this.configService,
      env,
      logger: this.logger
    };
    this.analytics = new _coreAnalyticsServerInternal.AnalyticsService(core);
    this.context = new _coreHttpContextServerInternal.ContextService(core);
    this.http = new _coreHttpServerInternal.HttpService(core);
    this.rendering = new _coreRenderingServerInternal.RenderingService(core);
    this.plugins = new _corePluginsServerInternal.PluginsService(core);
    this.elasticsearch = new _coreElasticsearchServerInternal.ElasticsearchService(core);
    this.savedObjects = new _coreSavedObjectsServerInternal.SavedObjectsService(core);
    this.uiSettings = new _coreUiSettingsServerInternal.UiSettingsService(core);
    this.capabilities = new _coreCapabilitiesServerInternal.CapabilitiesService(core);
    this.environment = new _coreEnvironmentServerInternal.EnvironmentService(core);
    this.node = new _coreNodeServerInternal.NodeService(core);
    this.metrics = new _coreMetricsServerInternal.MetricsService(core);
    this.status = new _coreStatusServerInternal.StatusService(core);
    this.coreApp = new _coreAppsServerInternal.CoreAppsService(core);
    this.httpResources = new _coreHttpResourcesServerInternal.HttpResourcesService(core);
    this.logging = new _coreLoggingServerInternal.LoggingService(core);
    this.coreUsageData = new _coreUsageDataServerInternal.CoreUsageDataService(core);
    this.i18n = new _coreI18nServerInternal.I18nService(core);
    this.deprecations = new _coreDeprecationsServerInternal.DeprecationsService(core);
    this.executionContext = new _coreExecutionContextServerInternal.ExecutionContextService(core);
    this.prebootService = new _corePrebootServerInternal.PrebootService(core);
    this.docLinks = new _coreDocLinksServerInternal.DocLinksService(core);
    this.customBranding = new _coreCustomBrandingServerInternal.CustomBrandingService(core);
    this.userSettingsService = new _coreUserSettingsServerInternal.UserSettingsService(core);
    this.savedObjectsStartPromise = new Promise(resolve => {
      this.resolveSavedObjectsStartPromise = resolve;
    });
    this.uptimePerStep.constructor = {
      start: constructorStartUptime,
      end: performance.now()
    };
  }
  async preboot() {
    this.log.debug('prebooting server');
    const prebootStartUptime = performance.now();
    const prebootTransaction = _elasticApmNode.default.startTransaction('server-preboot', 'kibana-platform');
    const analyticsPreboot = this.analytics.preboot();
    const environmentPreboot = await this.environment.preboot({
      analytics: analyticsPreboot
    });
    const nodePreboot = await this.node.preboot({
      loggingSystem: this.loggingSystem
    });
    this.nodeRoles = nodePreboot.roles;

    // Discover any plugins before continuing. This allows other systems to utilize the plugin dependency graph.
    this.discoveredPlugins = await this.plugins.discover({
      environment: environmentPreboot,
      node: nodePreboot
    });

    // Immediately terminate in case of invalid configuration. This needs to be done after plugin discovery. We also
    // silent deprecation warnings until `setup` stage where we'll validate config once again.
    await (0, _coreConfigServerInternal.ensureValidConfiguration)(this.configService, {
      logDeprecations: false
    });
    const {
      uiPlugins,
      pluginTree,
      pluginPaths
    } = this.discoveredPlugins.preboot;
    const contextServicePreboot = this.context.preboot({
      pluginDependencies: new Map([...pluginTree.asOpaqueIds])
    });
    const httpPreboot = await this.http.preboot({
      context: contextServicePreboot
    });

    // setup i18n prior to any other service, to have translations ready
    await this.i18n.preboot({
      http: httpPreboot,
      pluginPaths
    });
    this.capabilities.preboot({
      http: httpPreboot
    });
    const elasticsearchServicePreboot = await this.elasticsearch.preboot();
    const uiSettingsPreboot = await this.uiSettings.preboot();
    const renderingPreboot = await this.rendering.preboot({
      http: httpPreboot,
      uiPlugins
    });
    const httpResourcesPreboot = this.httpResources.preboot({
      http: httpPreboot,
      rendering: renderingPreboot
    });
    const loggingPreboot = this.logging.preboot({
      loggingSystem: this.loggingSystem
    });
    const corePreboot = {
      analytics: analyticsPreboot,
      context: contextServicePreboot,
      elasticsearch: elasticsearchServicePreboot,
      http: httpPreboot,
      uiSettings: uiSettingsPreboot,
      httpResources: httpResourcesPreboot,
      logging: loggingPreboot,
      preboot: this.prebootService.preboot()
    };
    await this.plugins.preboot(corePreboot);
    httpPreboot.registerRouteHandlerContext(coreId, 'core', () => {
      return new _coreHttpRequestHandlerContextServerInternal.PrebootCoreRouteHandlerContext(corePreboot);
    });
    this.coreApp.preboot(corePreboot, uiPlugins);
    prebootTransaction === null || prebootTransaction === void 0 ? void 0 : prebootTransaction.end();
    this.uptimePerStep.preboot = {
      start: prebootStartUptime,
      end: performance.now()
    };
    return corePreboot;
  }
  async setup() {
    this.log.debug('setting up server');
    const setupStartUptime = performance.now();
    const setupTransaction = _elasticApmNode.default.startTransaction('server-setup', 'kibana-platform');
    const analyticsSetup = this.analytics.setup();
    this.registerKibanaStartedEventType(analyticsSetup);
    const environmentSetup = this.environment.setup();

    // Configuration could have changed after preboot.
    await (0, _coreConfigServerInternal.ensureValidConfiguration)(this.configService);
    const {
      uiPlugins,
      pluginPaths,
      pluginTree
    } = this.discoveredPlugins.standard;
    const contextServiceSetup = this.context.setup({
      pluginDependencies: new Map([...pluginTree.asOpaqueIds])
    });
    const executionContextSetup = this.executionContext.setup();
    const docLinksSetup = this.docLinks.setup();
    const httpSetup = await this.http.setup({
      context: contextServiceSetup,
      executionContext: executionContextSetup
    });
    const deprecationsSetup = await this.deprecations.setup({
      http: httpSetup
    });

    // setup i18n prior to any other service, to have translations ready
    const i18nServiceSetup = await this.i18n.setup({
      http: httpSetup,
      pluginPaths
    });
    const capabilitiesSetup = this.capabilities.setup({
      http: httpSetup
    });
    const elasticsearchServiceSetup = await this.elasticsearch.setup({
      analytics: analyticsSetup,
      http: httpSetup,
      executionContext: executionContextSetup
    });
    const metricsSetup = await this.metrics.setup({
      http: httpSetup,
      elasticsearchService: elasticsearchServiceSetup
    });
    const coreUsageDataSetup = this.coreUsageData.setup({
      http: httpSetup,
      metrics: metricsSetup,
      savedObjectsStartPromise: this.savedObjectsStartPromise,
      changedDeprecatedConfigPath$: this.configService.getDeprecatedConfigPath$()
    });
    const savedObjectsSetup = await this.savedObjects.setup({
      http: httpSetup,
      elasticsearch: elasticsearchServiceSetup,
      deprecations: deprecationsSetup,
      coreUsageData: coreUsageDataSetup
    });
    const uiSettingsSetup = await this.uiSettings.setup({
      http: httpSetup,
      savedObjects: savedObjectsSetup
    });
    const statusSetup = await this.status.setup({
      analytics: analyticsSetup,
      elasticsearch: elasticsearchServiceSetup,
      pluginDependencies: pluginTree.asNames,
      savedObjects: savedObjectsSetup,
      environment: environmentSetup,
      http: httpSetup,
      metrics: metricsSetup,
      coreUsageData: coreUsageDataSetup
    });
    const customBrandingSetup = this.customBranding.setup();
    const userSettingsServiceSetup = this.userSettingsService.setup();
    const renderingSetup = await this.rendering.setup({
      elasticsearch: elasticsearchServiceSetup,
      http: httpSetup,
      status: statusSetup,
      uiPlugins,
      customBranding: customBrandingSetup,
      userSettings: userSettingsServiceSetup
    });
    const httpResourcesSetup = this.httpResources.setup({
      http: httpSetup,
      rendering: renderingSetup
    });
    const loggingSetup = this.logging.setup();
    const coreSetup = {
      analytics: analyticsSetup,
      capabilities: capabilitiesSetup,
      context: contextServiceSetup,
      customBranding: customBrandingSetup,
      docLinks: docLinksSetup,
      elasticsearch: elasticsearchServiceSetup,
      environment: environmentSetup,
      executionContext: executionContextSetup,
      http: httpSetup,
      i18n: i18nServiceSetup,
      savedObjects: savedObjectsSetup,
      status: statusSetup,
      uiSettings: uiSettingsSetup,
      rendering: renderingSetup,
      httpResources: httpResourcesSetup,
      logging: loggingSetup,
      metrics: metricsSetup,
      deprecations: deprecationsSetup,
      coreUsageData: coreUsageDataSetup,
      userSettings: userSettingsServiceSetup
    };
    const pluginsSetup = await this.plugins.setup(coreSetup);
    (0, _classPrivateFieldSet2.default)(this, _pluginsInitialized, pluginsSetup.initialized);
    this.registerCoreContext(coreSetup);
    this.coreApp.setup(coreSetup, uiPlugins);
    setupTransaction === null || setupTransaction === void 0 ? void 0 : setupTransaction.end();
    this.uptimePerStep.setup = {
      start: setupStartUptime,
      end: performance.now()
    };
    return coreSetup;
  }
  async start() {
    var _this$nodeRoles;
    this.log.debug('starting server');
    const startStartUptime = performance.now();
    const startTransaction = _elasticApmNode.default.startTransaction('server-start', 'kibana-platform');
    const analyticsStart = this.analytics.start();
    const executionContextStart = this.executionContext.start();
    const docLinkStart = this.docLinks.start();
    const elasticsearchStart = await this.elasticsearch.start();
    const deprecationsStart = this.deprecations.start();
    const soStartSpan = startTransaction === null || startTransaction === void 0 ? void 0 : startTransaction.startSpan('saved_objects.migration', 'migration');
    const savedObjectsStart = await this.savedObjects.start({
      elasticsearch: elasticsearchStart,
      pluginsInitialized: (0, _classPrivateFieldGet2.default)(this, _pluginsInitialized),
      docLinks: docLinkStart,
      node: await this.node.start()
    });
    await this.resolveSavedObjectsStartPromise(savedObjectsStart);
    soStartSpan === null || soStartSpan === void 0 ? void 0 : soStartSpan.end();
    if (((_this$nodeRoles = this.nodeRoles) === null || _this$nodeRoles === void 0 ? void 0 : _this$nodeRoles.migrator) === true) {
      startTransaction === null || startTransaction === void 0 ? void 0 : startTransaction.end();
      this.log.info('Detected migrator node role; shutting down Kibana...');
      throw new _coreBaseServerInternal.CriticalError('Migrations completed, shutting down Kibana', _constants.MIGRATION_EXCEPTION_CODE, 0);
    }
    const capabilitiesStart = this.capabilities.start();
    const uiSettingsStart = await this.uiSettings.start();
    const customBrandingStart = this.customBranding.start();
    const metricsStart = await this.metrics.start();
    const httpStart = this.http.getStartContract();
    const coreUsageDataStart = this.coreUsageData.start({
      elasticsearch: elasticsearchStart,
      savedObjects: savedObjectsStart,
      exposedConfigsToUsage: this.plugins.getExposedPluginConfigsToUsage()
    });
    this.status.start();
    this.coreStart = {
      analytics: analyticsStart,
      capabilities: capabilitiesStart,
      customBranding: customBrandingStart,
      docLinks: docLinkStart,
      elasticsearch: elasticsearchStart,
      executionContext: executionContextStart,
      http: httpStart,
      metrics: metricsStart,
      savedObjects: savedObjectsStart,
      uiSettings: uiSettingsStart,
      coreUsageData: coreUsageDataStart,
      deprecations: deprecationsStart
    };
    await this.plugins.start(this.coreStart);
    await this.http.start();
    startTransaction === null || startTransaction === void 0 ? void 0 : startTransaction.end();
    this.uptimePerStep.start = {
      start: startStartUptime,
      end: performance.now()
    };
    this.reportKibanaStartedEvents(analyticsStart);
    return this.coreStart;
  }
  async stop() {
    this.log.debug('stopping server');
    await this.analytics.stop();
    await this.http.stop(); // HTTP server has to stop before savedObjects and ES clients are closed to be able to gracefully attempt to resolve any pending requests
    await this.plugins.stop();
    await this.savedObjects.stop();
    await this.elasticsearch.stop();
    await this.uiSettings.stop();
    await this.rendering.stop();
    await this.metrics.stop();
    await this.status.stop();
    await this.logging.stop();
    await this.customBranding.stop();
    this.node.stop();
    this.deprecations.stop();
  }
  registerCoreContext(coreSetup) {
    coreSetup.http.registerRouteHandlerContext(coreId, 'core', (context, req) => {
      return new _coreHttpRequestHandlerContextServerInternal.CoreRouteHandlerContext(this.coreStart, req);
    });
  }
  setupCoreConfig() {
    (0, _register_service_config.registerServiceConfig)(this.configService);
  }

  /**
   * Register the legacy KIBANA_STARTED_EVENT.
   * @param analyticsSetup The {@link AnalyticsServiceSetup}
   * @private
   */
  registerKibanaStartedEventType(analyticsSetup) {
    analyticsSetup.registerEventType({
      eventType: KIBANA_STARTED_EVENT,
      schema: {
        uptime_per_step: {
          properties: {
            constructor: {
              properties: {
                start: {
                  type: 'float',
                  _meta: {
                    description: 'Number of seconds the Node.js process has been running until the constructor was called'
                  }
                },
                end: {
                  type: 'float',
                  _meta: {
                    description: 'Number of seconds the Node.js process has been running until the constructor finished'
                  }
                }
              }
            },
            preboot: {
              properties: {
                start: {
                  type: 'float',
                  _meta: {
                    description: 'Number of seconds the Node.js process has been running until `preboot` was called'
                  }
                },
                end: {
                  type: 'float',
                  _meta: {
                    description: 'Number of seconds the Node.js process has been running until `preboot` finished'
                  }
                }
              }
            },
            setup: {
              properties: {
                start: {
                  type: 'float',
                  _meta: {
                    description: 'Number of seconds the Node.js process has been running until `setup` was called'
                  }
                },
                end: {
                  type: 'float',
                  _meta: {
                    description: 'Number of seconds the Node.js process has been running until `setup` finished'
                  }
                }
              }
            },
            start: {
              properties: {
                start: {
                  type: 'float',
                  _meta: {
                    description: 'Number of seconds the Node.js process has been running until `start` was called'
                  }
                },
                end: {
                  type: 'float',
                  _meta: {
                    description: 'Number of seconds the Node.js process has been running until `start` finished'
                  }
                }
              }
            }
          },
          _meta: {
            description: 'Number of seconds the Node.js process has been running until each phase of the server execution is called and finished.'
          }
        }
      }
    });
  }

  /**
   * Reports the new and legacy KIBANA_STARTED_EVENT.
   * @param analyticsStart The {@link AnalyticsServiceStart}.
   * @private
   */
  reportKibanaStartedEvents(analyticsStart) {
    // Report the legacy KIBANA_STARTED_EVENT.
    analyticsStart.reportEvent(KIBANA_STARTED_EVENT, {
      uptime_per_step: this.uptimePerStep
    });
    const ups = this.uptimePerStep;

    // Report the metric-shaped KIBANA_STARTED_EVENT.
    (0, _ebtTools.reportPerformanceMetricEvent)(analyticsStart, {
      eventName: KIBANA_STARTED_EVENT,
      duration: ups.start.end - ups.constructor.start,
      key1: 'time_to_constructor',
      value1: ups.constructor.start,
      key2: 'constructor_time',
      value2: ups.constructor.end - ups.constructor.start,
      key3: 'preboot_time',
      value3: ups.preboot.end - ups.preboot.start,
      key4: 'setup_time',
      value4: ups.setup.end - ups.setup.start,
      key5: 'start_time',
      value5: ups.start.end - ups.start.start
    });
  }
}
exports.Server = Server;