"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.pluginManifestFromPluginPackage = pluginManifestFromPluginPackage;
var _lodash = require("lodash");
var _coreBaseCommon = require("@kbn/core-base-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function pluginManifestFromPluginPackage(kibanaVersion, manifest) {
  var _manifest$plugin$opti, _manifest$plugin$requ, _manifest$plugin$requ2, _manifest$plugin$conf;
  return {
    type: manifest.plugin.type === 'preboot' ? _coreBaseCommon.PluginType.preboot : _coreBaseCommon.PluginType.standard,
    id: manifest.plugin.id,
    version: '1.0.0',
    enabledOnAnonymousPages: manifest.plugin.enabledOnAnonymousPages,
    serviceFolders: manifest.serviceFolders,
    kibanaVersion,
    optionalPlugins: (_manifest$plugin$opti = manifest.plugin.optionalPlugins) !== null && _manifest$plugin$opti !== void 0 ? _manifest$plugin$opti : [],
    requiredBundles: (_manifest$plugin$requ = manifest.plugin.requiredBundles) !== null && _manifest$plugin$requ !== void 0 ? _manifest$plugin$requ : [],
    requiredPlugins: (_manifest$plugin$requ2 = manifest.plugin.requiredPlugins) !== null && _manifest$plugin$requ2 !== void 0 ? _manifest$plugin$requ2 : [],
    owner: {
      name: manifest.owner.join(' & ')
    },
    server: manifest.plugin.server,
    ui: manifest.plugin.browser,
    configPath: (_manifest$plugin$conf = manifest.plugin.configPath) !== null && _manifest$plugin$conf !== void 0 ? _manifest$plugin$conf : (0, _lodash.snakeCase)(manifest.plugin.id)
  };
}