"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rolesConfig = exports.nodeConfig = exports.NODE_WILDCARD_CHAR = exports.NODE_UI_ROLE = exports.NODE_MIGRATOR_ROLE = exports.NODE_DEFAULT_ROLES = exports.NODE_CONFIG_PATH = exports.NODE_BACKGROUND_TASKS_ROLE = exports.NODE_ALL_ROLES = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */
const NODE_CONFIG_PATH = 'node';
/**
 * Wildchar is a special config option that implies all {@link NODE_DEFAULT_ROLES} roles.
 * @internal
 */
exports.NODE_CONFIG_PATH = NODE_CONFIG_PATH;
const NODE_WILDCARD_CHAR = '*';
/** @internal */
exports.NODE_WILDCARD_CHAR = NODE_WILDCARD_CHAR;
const NODE_BACKGROUND_TASKS_ROLE = 'background_tasks';
/** @internal */
exports.NODE_BACKGROUND_TASKS_ROLE = NODE_BACKGROUND_TASKS_ROLE;
const NODE_UI_ROLE = 'ui';
/** @internal */
exports.NODE_UI_ROLE = NODE_UI_ROLE;
const NODE_MIGRATOR_ROLE = 'migrator';
/** @internal */
exports.NODE_MIGRATOR_ROLE = NODE_MIGRATOR_ROLE;
const NODE_DEFAULT_ROLES = [NODE_BACKGROUND_TASKS_ROLE, NODE_UI_ROLE];
/** @internal */
exports.NODE_DEFAULT_ROLES = NODE_DEFAULT_ROLES;
const NODE_ALL_ROLES = [NODE_UI_ROLE, NODE_MIGRATOR_ROLE, NODE_BACKGROUND_TASKS_ROLE];

/** @internal */
exports.NODE_ALL_ROLES = NODE_ALL_ROLES;
const rolesConfig = _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal(NODE_BACKGROUND_TASKS_ROLE), _configSchema.schema.literal(NODE_MIGRATOR_ROLE), _configSchema.schema.literal(NODE_WILDCARD_CHAR), _configSchema.schema.literal(NODE_UI_ROLE)]), {
  defaultValue: [NODE_WILDCARD_CHAR],
  minSize: 1,
  validate: value => {
    if (value.length > 1) {
      if (value.includes(NODE_WILDCARD_CHAR)) {
        return `wildcard ("*") cannot be used with other roles or specified more than once`;
      }
      if (value.includes(NODE_MIGRATOR_ROLE)) {
        return `"migrator" cannot be used with other roles or specified more than once`;
      }
    }
  }
});

/** @internal */
exports.rolesConfig = rolesConfig;
const configSchema = _configSchema.schema.object({
  roles: rolesConfig
});

/** @internal */
const nodeConfig = {
  path: NODE_CONFIG_PATH,
  schema: configSchema
};
exports.nodeConfig = nodeConfig;