"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.adoptToHapiOnRequest = adoptToHapiOnRequest;
var _coreHttpServer = require("@kbn/core-http-server");
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const preRoutingResult = {
  next() {
    return {
      type: _coreHttpServer.OnPreRoutingResultType.next
    };
  },
  rewriteUrl(url) {
    return {
      type: _coreHttpServer.OnPreRoutingResultType.rewriteUrl,
      url
    };
  },
  isNext(result) {
    return result && result.type === _coreHttpServer.OnPreRoutingResultType.next;
  },
  isRewriteUrl(result) {
    return result && result.type === _coreHttpServer.OnPreRoutingResultType.rewriteUrl;
  }
};
const toolkit = {
  next: preRoutingResult.next,
  rewriteUrl: preRoutingResult.rewriteUrl
};

/**
 * Adopt custom request interceptor to Hapi lifecycle system.
 * @param fn - an extension point allowing to perform custom logic for
 * incoming HTTP requests.
 */
function adoptToHapiOnRequest(fn, log) {
  return async function interceptPreRoutingRequest(request, responseToolkit) {
    const hapiResponseAdapter = new _coreHttpRouterServerInternal.HapiResponseAdapter(responseToolkit);
    try {
      const result = await fn(_coreHttpRouterServerInternal.CoreKibanaRequest.from(request), _coreHttpRouterServerInternal.lifecycleResponseFactory, toolkit);
      if ((0, _coreHttpRouterServerInternal.isKibanaResponse)(result)) {
        return hapiResponseAdapter.handle(result);
      }
      if (preRoutingResult.isNext(result)) {
        return responseToolkit.continue;
      }
      if (preRoutingResult.isRewriteUrl(result)) {
        var _appState$rewrittenUr;
        const appState = request.app;
        appState.rewrittenUrl = (_appState$rewrittenUr = appState.rewrittenUrl) !== null && _appState$rewrittenUr !== void 0 ? _appState$rewrittenUr : request.url;
        const {
          url
        } = result;
        request.setUrl(url);

        // We should update raw request as well since it can be proxied to the old platform
        request.raw.req.url = url;
        return responseToolkit.continue;
      }
      throw new Error(`Unexpected result from OnPreRouting. Expected OnPreRoutingResult or KibanaResponse, but given: ${result}.`);
    } catch (error) {
      log.error(error);
      return hapiResponseAdapter.toInternalError();
    }
  };
}