"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BasePath = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _std = require("@kbn/std");
var _coreHttpRouterServerInternal = require("@kbn/core-http-router-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Core internal implementation of {@link IBasePath}
 *
 * @internal
 */
class BasePath {
  constructor(serverBasePath = '', publicBaseUrl) {
    (0, _defineProperty2.default)(this, "basePathCache", new WeakMap());
    (0, _defineProperty2.default)(this, "serverBasePath", void 0);
    (0, _defineProperty2.default)(this, "publicBaseUrl", void 0);
    (0, _defineProperty2.default)(this, "get", request => {
      const requestScopePath = this.basePathCache.get((0, _coreHttpRouterServerInternal.ensureRawRequest)(request)) || '';
      return `${this.serverBasePath}${requestScopePath}`;
    });
    (0, _defineProperty2.default)(this, "set", (request, requestSpecificBasePath) => {
      const rawRequest = (0, _coreHttpRouterServerInternal.ensureRawRequest)(request);
      if (this.basePathCache.has(rawRequest)) {
        throw new Error('Request basePath was previously set. Setting multiple times is not supported.');
      }
      this.basePathCache.set(rawRequest, requestSpecificBasePath);
    });
    (0, _defineProperty2.default)(this, "prepend", path => {
      if (this.serverBasePath === '') return path;
      return (0, _std.modifyUrl)(path, parts => {
        if (!parts.hostname && parts.pathname && parts.pathname.startsWith('/')) {
          parts.pathname = `${this.serverBasePath}${parts.pathname}`;
        }
      });
    });
    (0, _defineProperty2.default)(this, "remove", path => {
      if (this.serverBasePath === '') {
        return path;
      }
      if (path === this.serverBasePath) {
        return '/';
      }
      if (path.startsWith(`${this.serverBasePath}/`)) {
        return path.slice(this.serverBasePath.length);
      }
      return path;
    });
    this.serverBasePath = serverBasePath;
    this.publicBaseUrl = publicBaseUrl;
  }
}
exports.BasePath = BasePath;