"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validate = validate;
var _validator = require("../validator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** Will throw if any of the validation checks fail */
function validate(data, runtimeSchema, version) {
  const validator = _validator.RouteValidator.from(runtimeSchema);
  return {
    body: validator.getBody(data.body, `get ${version} body`),
    params: validator.getParams(data.params, `get ${version} params`),
    query: validator.getQuery(data.query, `get ${version} query`)
  };
}