"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupOptionsListClusterSettingsRoute = void 0;
var _server = require("@kbn/kibana-utils-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const setupOptionsListClusterSettingsRoute = ({
  http
}) => {
  const router = http.createRouter();
  router.get({
    path: '/api/kibana/controls/optionsList/getExpensiveQueriesSetting',
    validate: false
  }, async (context, _, response) => {
    try {
      var _ref, _ref2, _settings$transient$s, _settings$transient, _settings$transient$s2, _settings$persistent, _settings$persistent$, _settings$defaults, _settings$defaults$se;
      /**
       *  using internal user here because in many cases the logged in user will not have the monitor permission required
       * to check cluster settings. This endpoint does not take a query, params, or a body, so there is no chance of leaking info.
       */
      const esClient = (await context.core).elasticsearch.client.asInternalUser;
      const settings = await esClient.cluster.getSettings({
        include_defaults: true,
        filter_path: '**.allow_expensive_queries'
      });

      // priority: transient -> persistent -> default
      const allowExpensiveQueries = (_ref = (_ref2 = (_settings$transient$s = (_settings$transient = settings.transient) === null || _settings$transient === void 0 ? void 0 : (_settings$transient$s2 = _settings$transient.search) === null || _settings$transient$s2 === void 0 ? void 0 : _settings$transient$s2.allow_expensive_queries) !== null && _settings$transient$s !== void 0 ? _settings$transient$s : (_settings$persistent = settings.persistent) === null || _settings$persistent === void 0 ? void 0 : (_settings$persistent$ = _settings$persistent.search) === null || _settings$persistent$ === void 0 ? void 0 : _settings$persistent$.allow_expensive_queries) !== null && _ref2 !== void 0 ? _ref2 : (_settings$defaults = settings.defaults) === null || _settings$defaults === void 0 ? void 0 : (_settings$defaults$se = _settings$defaults.search) === null || _settings$defaults$se === void 0 ? void 0 : _settings$defaults$se.allow_expensive_queries) !== null && _ref !== void 0 ? _ref :
      // by default, the allowExpensiveQueries cluster setting is undefined; so, we need to treat this the same
      // as `true` since that's the way other applications (such as the dashboard listing page) handle this.
      'true';
      return response.ok({
        body: {
          allowExpensiveQueries: allowExpensiveQueries === 'true'
        }
      });
    } catch (e) {
      const kbnErr = (0, _server.getKbnServerError)(e);
      return (0, _server.reportServerError)(response, kbnErr);
    }
  });
};
exports.setupOptionsListClusterSettingsRoute = setupOptionsListClusterSettingsRoute;