"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSliderPopoverContent = TimeSliderPopoverContent;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _time_slider_selectors = require("../time_slider_selectors");
var _time_slider_strings = require("./time_slider_strings");
var _time_slider_embeddable = require("../embeddable/time_slider_embeddable");
var _time_slider_anchored_range = require("./time_slider_anchored_range");
var _time_slider_sliding_window_range = require("./time_slider_sliding_window_range");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function TimeSliderPopoverContent(props) {
  const ticks = props.ticks.length <= 12 ? props.ticks : props.ticks.map((tick, index) => {
    return {
      value: tick.value,
      // to avoid label overlap, only display even tick labels
      // Passing empty string as tick label results in tick not rendering, so must wrap empty label in react element
      // Can not store react node in redux state because its not serializable so have to transform into react node here
      label: index % 2 === 0 ? tick.label : /*#__PURE__*/_react.default.createElement("span", null, "\xA0")
    };
  });
  const timeSlider = (0, _time_slider_embeddable.useTimeSlider)();
  const isAnchored = timeSlider.select(_time_slider_selectors.getIsAnchored);
  const rangeInput = isAnchored ? /*#__PURE__*/_react.default.createElement(_time_slider_anchored_range.TimeSliderAnchoredRange, {
    value: props.value,
    onChange: props.onChange,
    stepSize: props.stepSize,
    ticks: ticks,
    timeRangeMin: props.timeRangeMin,
    timeRangeMax: props.timeRangeMax
  }) : /*#__PURE__*/_react.default.createElement(_time_slider_sliding_window_range.TimeSliderSlidingWindowRange, {
    value: props.value,
    onChange: props.onChange,
    stepSize: props.stepSize,
    rangeRef: props.rangeRef,
    ticks: ticks,
    timeRangeMin: props.timeRangeMin,
    timeRangeMax: props.timeRangeMax
  });
  const anchorStartToggleButtonLabel = isAnchored ? _time_slider_strings.TimeSliderStrings.control.getUnpinStart() : _time_slider_strings.TimeSliderStrings.control.getPinStart();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "rangeSlider__actions",
    gutterSize: "none",
    "data-test-subj": "timeSlider-popoverContents",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: anchorStartToggleButtonLabel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isAnchored ? 'pinFilled' : 'pin',
    onClick: () => {
      const nextIsAnchored = !isAnchored;
      if (nextIsAnchored) {
        props.onChange([props.timeRangeMin, props.value[1]]);
      }
      timeSlider.dispatch.setIsAnchored({
        isAnchored: nextIsAnchored
      });
    },
    "aria-label": anchorStartToggleButtonLabel,
    "data-test-subj": "timeSlider__anchorStartToggleButton"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, rangeInput), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _time_slider_strings.TimeSliderStrings.control.getClearSelection()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "eraser",
    color: "danger",
    onClick: props.onClear,
    "aria-label": _time_slider_strings.TimeSliderStrings.control.getClearSelection(),
    "data-test-subj": "timeSlider__clearTimeButton"
  }))));
}