"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSliderPopoverButton = TimeSliderPopoverButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function TimeSliderPopoverButton(props) {
  return /*#__PURE__*/_react.default.createElement("button", {
    className: "timeSlider__anchor eui-textTruncate",
    color: "text",
    onClick: props.onClick,
    "data-test-subj": "timeSlider-popoverToggleButton"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textTruncate",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("span", null, props.formatDate(props.from)), "\xA0\xA0\u2192\xA0\xA0", /*#__PURE__*/_react.default.createElement("span", null, props.formatDate(props.to))));
}