"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataServiceFactory = void 0;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const minMaxAgg = field => {
  const aggBody = {};
  if (field) {
    if (field.scripted) {
      aggBody.script = {
        source: field.script,
        lang: field.lang
      };
    } else {
      aggBody.field = field.name;
    }
  }
  return {
    maxAgg: {
      max: aggBody
    },
    minAgg: {
      min: aggBody
    }
  };
};
const dataServiceFactory = ({
  startPlugins
}) => {
  const {
    data: {
      query: queryPlugin,
      search
    }
  } = startPlugins;
  const {
    data
  } = startPlugins;
  const fetchFieldRange = async (dataView, fieldName, input) => {
    const {
      ignoreParentSettings,
      query,
      timeRange
    } = input;
    let {
      filters = []
    } = input;
    const field = dataView.getFieldByName(fieldName);
    if (!field) {
      throw new Error('Field Missing Error');
    }
    if (timeRange) {
      const timeFilter = data.query.timefilter.timefilter.createFilter(dataView, timeRange);
      if (timeFilter) {
        filters = filters.concat(timeFilter);
      }
    }
    const searchSource = await data.search.searchSource.create();
    searchSource.setField('size', 0);
    searchSource.setField('index', dataView);
    const aggs = minMaxAgg(field);
    searchSource.setField('aggs', aggs);
    searchSource.setField('filter', ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreFilters ? [] : filters);
    searchSource.setField('query', ignoreParentSettings !== null && ignoreParentSettings !== void 0 && ignoreParentSettings.ignoreQuery ? undefined : query);
    const resp = await (0, _rxjs.lastValueFrom)(searchSource.fetch$());
    const min = (0, _lodash.get)(resp, 'rawResponse.aggregations.minAgg.value', undefined);
    const max = (0, _lodash.get)(resp, 'rawResponse.aggregations.maxAgg.value', undefined);
    return {
      min: min === null ? undefined : min,
      max: max === null ? undefined : max
    };
  };
  return {
    fetchFieldRange,
    query: queryPlugin,
    searchSource: search.searchSource,
    timefilter: queryPlugin.timefilter.timefilter
  };
};
exports.dataServiceFactory = dataServiceFactory;