"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeSliderEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _public = require("@kbn/presentation-util-plugin/public");
var _range_slider_persistable_state = require("../../../common/range_slider/range_slider_persistable_state");
var _types = require("../../../common/range_slider/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class RangeSliderEmbeddableFactory {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _types.RANGE_SLIDER_CONTROL);
    (0, _defineProperty2.default)(this, "getDisplayName", () => _i18n.i18n.translate('controls.rangeSlider.displayName', {
      defaultMessage: 'Range slider'
    }));
    (0, _defineProperty2.default)(this, "getDescription", () => _i18n.i18n.translate('controls.rangeSlider.description', {
      defaultMessage: 'Add a control for selecting a range of field values.'
    }));
    (0, _defineProperty2.default)(this, "getIconType", () => 'controlsHorizontal');
    (0, _defineProperty2.default)(this, "canCreateNew", () => false);
    (0, _defineProperty2.default)(this, "isEditable", () => Promise.resolve(true));
    (0, _defineProperty2.default)(this, "presaveTransformFunction", (newInput, embeddable) => {
      if (embeddable && (newInput.fieldName && !(0, _fastDeepEqual.default)(newInput.fieldName, embeddable.getInput().fieldName) || newInput.dataViewId && !(0, _fastDeepEqual.default)(newInput.dataViewId, embeddable.getInput().dataViewId))) {
        // if the field name or data view id has changed in this editing session, selected values are invalid, so reset them.
        newInput.value = ['', ''];
      }
      return newInput;
    });
    (0, _defineProperty2.default)(this, "isFieldCompatible", field => {
      return field.aggregatable && field.type === 'number';
    });
    (0, _defineProperty2.default)(this, "inject", (0, _range_slider_persistable_state.createRangeSliderInject)());
    (0, _defineProperty2.default)(this, "extract", (0, _range_slider_persistable_state.createRangeSliderExtract)());
  }
  async create(initialInput, parent) {
    const reduxEmbeddablePackage = await (0, _public.lazyLoadReduxToolsPackage)();
    const {
      RangeSliderEmbeddable
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./range_slider_embeddable')));
    return Promise.resolve(new RangeSliderEmbeddable(reduxEmbeddablePackage, initialInput, {}, parent));
  }
}
exports.RangeSliderEmbeddableFactory = RangeSliderEmbeddableFactory;