"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeSliderPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _eui = require("@elastic/eui");
var _services = require("../../services");
var _range_slider_strings = require("./range_slider_strings");
var _range_slider_embeddable = require("../embeddable/range_slider_embeddable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const RangeSliderPopover = ({
  rangeRef
}) => {
  var _rangeSlider$select;
  const [fieldFormatter, setFieldFormatter] = (0, _react.useState)(() => toFormat => toFormat);

  // Controls Services Context
  const {
    dataViews: {
      get: getDataViewById
    }
  } = _services.pluginServices.getServices();
  const rangeSlider = (0, _range_slider_embeddable.useRangeSlider)();

  // Select current state from Redux using multiple selectors to avoid rerenders.
  const dataViewId = rangeSlider.select(state => state.output.dataViewId);
  const fieldSpec = rangeSlider.select(state => state.componentState.field);
  const id = rangeSlider.select(state => state.explicitInput.id);
  const isInvalid = rangeSlider.select(state => state.componentState.isInvalid);
  const max = rangeSlider.select(state => state.componentState.max);
  const min = rangeSlider.select(state => state.componentState.min);
  const title = rangeSlider.select(state => state.explicitInput.title);
  const value = (_rangeSlider$select = rangeSlider.select(state => state.explicitInput.value)) !== null && _rangeSlider$select !== void 0 ? _rangeSlider$select : ['', ''];
  const hasAvailableRange = min !== '' && max !== '';
  const hasLowerBoundSelection = value[0] !== '';
  const hasUpperBoundSelection = value[1] !== '';
  const lowerBoundSelection = parseFloat(value[0]);
  const upperBoundSelection = parseFloat(value[1]);
  const minValue = parseFloat(min);
  const maxValue = parseFloat(max);

  // EuiDualRange can only handle integers as min/max
  const roundedMin = hasAvailableRange ? Math.floor(minValue) : minValue;
  const roundedMax = hasAvailableRange ? Math.ceil(maxValue) : maxValue;

  // Caches min and max displayed on popover open so the range slider doesn't resize as selections change
  const [rangeSliderMin, setRangeSliderMin] = (0, _react.useState)(roundedMin);
  const [rangeSliderMax, setRangeSliderMax] = (0, _react.useState)(roundedMax);
  (0, _useMount.default)(() => {
    setRangeSliderMin(Math.min(roundedMin, isNaN(lowerBoundSelection) ? Infinity : lowerBoundSelection, isNaN(upperBoundSelection) ? Infinity : upperBoundSelection));
    setRangeSliderMax(Math.max(roundedMax, isNaN(lowerBoundSelection) ? -Infinity : lowerBoundSelection, isNaN(upperBoundSelection) ? -Infinity : upperBoundSelection));
  });
  const errorMessage = '';
  let helpText = '';
  if (!hasAvailableRange) {
    helpText = _range_slider_strings.RangeSliderStrings.popover.getNoAvailableDataHelpText();
  } else if (isInvalid) {
    helpText = _range_slider_strings.RangeSliderStrings.popover.getNoDataHelpText();
  }
  const displayedValue = [hasLowerBoundSelection ? String(lowerBoundSelection) : hasAvailableRange ? String(roundedMin) : '', hasUpperBoundSelection ? String(upperBoundSelection) : hasAvailableRange ? String(roundedMax) : ''];
  const ticks = [];
  const levels = [];
  if (hasAvailableRange) {
    ticks.push({
      value: rangeSliderMin,
      label: fieldFormatter(String(rangeSliderMin))
    });
    ticks.push({
      value: rangeSliderMax,
      label: fieldFormatter(String(rangeSliderMax))
    });
    levels.push({
      min: roundedMin,
      max: roundedMax,
      color: 'success'
    });
  }

  // derive field formatter from fieldSpec and dataViewId
  (0, _react.useEffect)(() => {
    (async () => {
      if (!dataViewId || !fieldSpec) return;
      // dataViews are cached, and should always be available without having to hit ES.
      const dataView = await getDataViewById(dataViewId);
      setFieldFormatter(() => {
        var _dataView$getFormatte;
        return (_dataView$getFormatte = dataView === null || dataView === void 0 ? void 0 : dataView.getFormatterForField(fieldSpec).getConverterFor('text')) !== null && _dataView$getFormatte !== void 0 ? _dataView$getFormatte : toFormat => toFormat;
      });
    })();
  }, [fieldSpec, dataViewId, getDataViewById]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "rangeSlider__actions",
    gutterSize: "none",
    "data-test-subj": "rangeSlider-control-actions",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDualRange, {
    id: id,
    min: hasAvailableRange ? rangeSliderMin : 0,
    max: hasAvailableRange ? rangeSliderMax : 100,
    onChange: ([newLowerBound, newUpperBound]) => {
      const updatedLowerBound = typeof newLowerBound === 'number' ? String(newLowerBound) : value[0];
      const updatedUpperBound = typeof newUpperBound === 'number' ? String(newUpperBound) : value[1];
      rangeSlider.dispatch.setSelectedRange([updatedLowerBound, updatedUpperBound]);
    },
    value: displayedValue,
    ticks: hasAvailableRange ? ticks : undefined,
    levels: hasAvailableRange ? levels : undefined,
    showTicks: hasAvailableRange,
    disabled: !hasAvailableRange,
    fullWidth: true,
    ref: rangeRef,
    "data-test-subj": "rangeSlider__slider"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: errorMessage ? 'danger' : 'default',
    "data-test-subj": "rangeSlider__helpText"
  }, errorMessage || helpText)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _range_slider_strings.RangeSliderStrings.popover.getClearRangeButtonTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "eraser",
    color: "danger",
    onClick: () => {
      rangeSlider.dispatch.setSelectedRange(['', '']);
    },
    "aria-label": _range_slider_strings.RangeSliderStrings.popover.getClearRangeButtonTitle(),
    "data-test-subj": "rangeSlider__clearRangeButton"
  })))));
};
exports.RangeSliderPopover = RangeSliderPopover;