"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeSliderControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _range_slider_embeddable = require("../embeddable/range_slider_embeddable");
var _range_slider_popover = require("./range_slider_popover");
require("./range_slider.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const INVALID_CLASS = 'rangeSliderAnchor__fieldNumber--invalid';
const RangeSliderControl = () => {
  var _rangeSlider$select;
  const rangeRef = (0, _react.useRef)(null);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const rangeSlider = (0, _range_slider_embeddable.useRangeSlider)();
  const min = rangeSlider.select(state => state.componentState.min);
  const max = rangeSlider.select(state => state.componentState.max);
  const isInvalid = rangeSlider.select(state => state.componentState.isInvalid);
  const id = rangeSlider.select(state => state.explicitInput.id);
  const value = (_rangeSlider$select = rangeSlider.select(state => state.explicitInput.value)) !== null && _rangeSlider$select !== void 0 ? _rangeSlider$select : ['', ''];
  const isLoading = rangeSlider.select(state => state.output.loading);
  const hasAvailableRange = min !== '' && max !== '';
  const hasLowerBoundSelection = value[0] !== '';
  const hasUpperBoundSelection = value[1] !== '';
  const lowerBoundValue = parseFloat(value[0]);
  const upperBoundValue = parseFloat(value[1]);
  const minValue = parseFloat(min);
  const maxValue = parseFloat(max);

  // EuiDualRange can only handle integers as min/max
  const roundedMin = hasAvailableRange ? Math.floor(minValue) : minValue;
  const roundedMax = hasAvailableRange ? Math.ceil(maxValue) : maxValue;
  const button = /*#__PURE__*/_react.default.createElement("button", {
    onClick: () => setIsPopoverOpen(!isPopoverOpen),
    className: "rangeSliderAnchor__button",
    "data-test-subj": `range-slider-control-${id}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    controlOnly: true,
    fullWidth: true,
    className: `rangeSliderAnchor__fieldNumber ${hasLowerBoundSelection && isInvalid ? INVALID_CLASS : ''}`,
    value: hasLowerBoundSelection ? lowerBoundValue : '',
    onChange: event => {
      rangeSlider.dispatch.setSelectedRange([event.target.value, isNaN(upperBoundValue) ? '' : String(upperBoundValue)]);
    },
    disabled: isLoading,
    placeholder: `${hasAvailableRange ? roundedMin : ''}`,
    isInvalid: isInvalid,
    "data-test-subj": "rangeSlider__lowerBoundFieldNumber"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "rangeSliderAnchor__delimiter",
    size: "s",
    color: "subdued"
  }, "\u2192")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    controlOnly: true,
    fullWidth: true,
    className: `rangeSliderAnchor__fieldNumber ${hasUpperBoundSelection && isInvalid ? INVALID_CLASS : ''}`,
    value: hasUpperBoundSelection ? upperBoundValue : '',
    onChange: event => {
      rangeSlider.dispatch.setSelectedRange([isNaN(lowerBoundValue) ? '' : String(lowerBoundValue), event.target.value]);
    },
    disabled: isLoading,
    placeholder: `${hasAvailableRange ? roundedMax : ''}`,
    isInvalid: isInvalid,
    "data-test-subj": "rangeSlider__upperBoundFieldNumber"
  })), isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "rangeSliderAnchor__spinner",
    "data-test-subj": "range-slider-loading-spinner"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)) : null));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    input: button,
    isOpen: isPopoverOpen,
    display: "block",
    panelPaddingSize: "s",
    className: "rangeSlider__popoverOverride",
    anchorClassName: "rangeSlider__anchorOverride",
    panelClassName: "rangeSlider__panelOverride",
    closePopover: () => setIsPopoverOpen(false),
    anchorPosition: "downCenter",
    attachToAnchor: false,
    disableFocusTrap: true,
    onPanelResize: width => {
      var _rangeRef$current;
      (_rangeRef$current = rangeRef.current) === null || _rangeRef$current === void 0 ? void 0 : _rangeRef$current.onResize(width);
    }
  }, /*#__PURE__*/_react.default.createElement(_range_slider_popover.RangeSliderPopover, {
    rangeRef: rangeRef
  }));
};
exports.RangeSliderControl = RangeSliderControl;