"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListEditorOptions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _suggestions_sorting = require("../../../common/options_list/suggestions_sorting");
var _options_list_strings = require("./options_list_strings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OptionsListEditorOptions = ({
  initialInput,
  onChange,
  fieldType
}) => {
  var _initialInput$sort$di, _initialInput$sort, _initialInput$sort$by, _initialInput$sort2;
  const [state, setState] = (0, _react.useState)({
    sortDirection: (_initialInput$sort$di = initialInput === null || initialInput === void 0 ? void 0 : (_initialInput$sort = initialInput.sort) === null || _initialInput$sort === void 0 ? void 0 : _initialInput$sort.direction) !== null && _initialInput$sort$di !== void 0 ? _initialInput$sort$di : _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.direction,
    sortBy: (_initialInput$sort$by = initialInput === null || initialInput === void 0 ? void 0 : (_initialInput$sort2 = initialInput.sort) === null || _initialInput$sort2 === void 0 ? void 0 : _initialInput$sort2.by) !== null && _initialInput$sort$by !== void 0 ? _initialInput$sort$by : _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.by,
    runPastTimeout: initialInput === null || initialInput === void 0 ? void 0 : initialInput.runPastTimeout,
    singleSelect: initialInput === null || initialInput === void 0 ? void 0 : initialInput.singleSelect,
    hideExclude: initialInput === null || initialInput === void 0 ? void 0 : initialInput.hideExclude,
    hideExists: initialInput === null || initialInput === void 0 ? void 0 : initialInput.hideExists,
    hideSort: initialInput === null || initialInput === void 0 ? void 0 : initialInput.hideSort
  });
  (0, _react.useEffect)(() => {
    // when field type changes, ensure that the selected sort type is still valid
    if (!(0, _suggestions_sorting.getCompatibleSortingTypes)(fieldType).includes(state.sortBy)) {
      onChange({
        sort: _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT
      });
      setState(s => ({
        ...s,
        sortBy: _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.by,
        sortDirection: _suggestions_sorting.OPTIONS_LIST_DEFAULT_SORT.direction
      }));
    }
  }, [fieldType, onChange, state.sortBy]);
  const SwitchWithTooltip = ({
    switchProps,
    label,
    tooltip
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, (0, _extends2.default)({
    label: label
  }, switchProps))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
          margin-top: 0px !important;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: tooltip,
    position: "right"
  })));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _options_list_strings.OptionsListStrings.editor.getAllowMultiselectTitle(),
    checked: !state.singleSelect,
    onChange: () => {
      onChange({
        singleSelect: !state.singleSelect
      });
      setState(s => ({
        ...s,
        singleSelect: !s.singleSelect
      }));
    },
    "data-test-subj": 'optionsListControl__allowMultipleAdditionalSetting'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(SwitchWithTooltip, {
    label: _options_list_strings.OptionsListStrings.editor.getRunPastTimeoutTitle(),
    tooltip: _options_list_strings.OptionsListStrings.editor.getRunPastTimeoutTooltip(),
    switchProps: {
      checked: Boolean(state.runPastTimeout),
      onChange: () => {
        onChange({
          runPastTimeout: !state.runPastTimeout
        });
        setState(s => ({
          ...s,
          runPastTimeout: !s.runPastTimeout
        }));
      }
    },
    "data-test-subj": 'optionsListControl__runPastTimeoutAdditionalSetting'
  })));
};
exports.OptionsListEditorOptions = OptionsListEditorOptions;