"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListControl = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../types");
var _options_list_strings = require("./options_list_strings");
var _options_list_popover = require("./options_list_popover");
var _options_list_embeddable = require("../embeddable/options_list_embeddable");
require("./options_list.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OptionsListControl = ({
  typeaheadSubject,
  loadMoreSubject
}) => {
  const resizeRef = (0, _react.useRef)(null);
  const optionsList = (0, _options_list_embeddable.useOptionsList)();
  const dimensions = (0, _eui.useResizeObserver)(resizeRef.current);
  const isPopoverOpen = optionsList.select(state => state.componentState.popoverOpen);
  const validSelections = optionsList.select(state => state.componentState.validSelections);
  const invalidSelections = optionsList.select(state => state.componentState.invalidSelections);
  const id = optionsList.select(state => state.explicitInput.id);
  const exclude = optionsList.select(state => state.explicitInput.exclude);
  const fieldName = optionsList.select(state => state.explicitInput.fieldName);
  const placeholder = optionsList.select(state => state.explicitInput.placeholder);
  const controlStyle = optionsList.select(state => state.explicitInput.controlStyle);
  const singleSelect = optionsList.select(state => state.explicitInput.singleSelect);
  const existsSelected = optionsList.select(state => state.explicitInput.existsSelected);
  const selectedOptions = optionsList.select(state => state.explicitInput.selectedOptions);
  const loading = optionsList.select(state => state.output.loading);
  (0, _react.useEffect)(() => {
    return () => {
      optionsList.dispatch.setPopoverOpen(false); // on unmount, close the popover
    };
  }, [optionsList]);

  // debounce loading state so loading doesn't flash when user types
  const [debouncedLoading, setDebouncedLoading] = (0, _react.useState)(true);
  const debounceSetLoading = (0, _react.useMemo)(() => (0, _lodash.debounce)(latestLoading => {
    setDebouncedLoading(latestLoading);
  }, 100), []);
  (0, _react.useEffect)(() => debounceSetLoading(loading !== null && loading !== void 0 ? loading : false), [loading, debounceSetLoading]);

  // remove all other selections if this control is single select
  (0, _react.useEffect)(() => {
    if (singleSelect && selectedOptions && (selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.length) > 1) {
      optionsList.dispatch.replaceSelection(selectedOptions[0]);
    }
  }, [selectedOptions, singleSelect, optionsList.dispatch]);
  const updateSearchString = (0, _react.useCallback)(newSearchString => {
    typeaheadSubject.next(newSearchString);
    optionsList.dispatch.setSearchString(newSearchString);
  }, [typeaheadSubject, optionsList.dispatch]);
  const loadMoreSuggestions = (0, _react.useCallback)(cardinality => {
    loadMoreSubject.next(Math.min(cardinality, _types.MAX_OPTIONS_LIST_REQUEST_SIZE));
  }, [loadMoreSubject]);
  const {
    hasSelections,
    selectionDisplayNode,
    validSelectionsCount
  } = (0, _react.useMemo)(() => {
    return {
      hasSelections: !(0, _lodash.isEmpty)(validSelections) || !(0, _lodash.isEmpty)(invalidSelections),
      validSelectionsCount: validSelections === null || validSelections === void 0 ? void 0 : validSelections.length,
      selectionDisplayNode: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, exclude && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
        className: "optionsList__negateLabel"
      }, existsSelected ? _options_list_strings.OptionsListStrings.control.getExcludeExists() : _options_list_strings.OptionsListStrings.control.getNegate()), ' '), existsSelected ? /*#__PURE__*/_react.default.createElement("span", {
        className: `optionsList__existsFilter`
      }, _options_list_strings.OptionsListStrings.controlAndPopover.getExists(+Boolean(exclude))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, validSelections && /*#__PURE__*/_react.default.createElement("span", null, validSelections.join(_options_list_strings.OptionsListStrings.control.getSeparator())), invalidSelections && /*#__PURE__*/_react.default.createElement("span", {
        className: "optionsList__filterInvalid"
      }, invalidSelections.join(_options_list_strings.OptionsListStrings.control.getSeparator()))))
    };
  }, [exclude, existsSelected, validSelections, invalidSelections]);
  const button = /*#__PURE__*/_react.default.createElement("div", {
    className: "optionsList--filterBtnWrapper",
    ref: resizeRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    isLoading: debouncedLoading,
    className: (0, _classnames.default)('optionsList--filterBtn', {
      'optionsList--filterBtnSingle': controlStyle !== 'twoLine',
      'optionsList--filterBtnPlaceholder': !hasSelections
    }),
    "data-test-subj": `optionsList-control-${id}`,
    onClick: () => optionsList.dispatch.setPopoverOpen(!isPopoverOpen),
    isSelected: isPopoverOpen,
    numActiveFilters: validSelectionsCount,
    hasActiveFilters: Boolean(validSelectionsCount)
  }, hasSelections || existsSelected ? selectionDisplayNode : placeholder !== null && placeholder !== void 0 ? placeholder : _options_list_strings.OptionsListStrings.control.getPlaceholder()));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    className: (0, _classnames.default)('optionsList--filterGroup', {
      'optionsList--filterGroupSingle': controlStyle !== 'twoLine'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: button,
    repositionOnScroll: true,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    anchorPosition: "downCenter",
    initialFocus: '[data-test-subj=optionsList-control-search-input]',
    className: "optionsList__popoverOverride",
    closePopover: () => optionsList.dispatch.setPopoverOpen(false),
    anchorClassName: "optionsList__anchorOverride",
    "aria-label": _options_list_strings.OptionsListStrings.popover.getAriaLabel(fieldName)
  }, /*#__PURE__*/_react.default.createElement(_options_list_popover.OptionsListPopover, {
    width: dimensions.width,
    isLoading: debouncedLoading,
    updateSearchString: updateSearchString,
    loadMoreSuggestions: loadMoreSuggestions
  })));
};
exports.OptionsListControl = OptionsListControl;