"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChildEmbeddable = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useChildEmbeddable = ({
  untilEmbeddableLoaded,
  embeddableId,
  embeddableType
}) => {
  const [embeddable, setEmbeddable] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    let mounted = true;
    (async () => {
      const newEmbeddable = await untilEmbeddableLoaded(embeddableId);
      if (!mounted) return;
      setEmbeddable(newEmbeddable);
    })();
    return () => {
      mounted = false;
    };
  }, [untilEmbeddableLoaded, embeddableId, embeddableType]);
  return embeddable;
};
exports.useChildEmbeddable = useChildEmbeddable;