"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlGroupRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _uuid = require("uuid");
var _esQuery = require("@kbn/es-query");
var _types = require("../types");
var _control_group_api = require("./control_group_api");
var _common = require("../../../common");
var _control_group_input_builder = require("./control_group_input_builder");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const ControlGroupRenderer = /*#__PURE__*/(0, _react.forwardRef)(({
  getCreationOptions,
  filters,
  timeRange,
  query
}, ref) => {
  const [controlGroup, setControlGroup] = (0, _react.useState)();
  (0, _react.useImperativeHandle)(ref, () => (0, _control_group_api.buildApiFromControlGroupContainer)(controlGroup), [controlGroup]);
  const controlGroupDomRef = (0, _react.useRef)(null);
  const id = (0, _react.useMemo)(() => (0, _uuid.v4)(), []);

  // onMount
  (0, _react.useEffect)(() => {
    let canceled = false;
    let destroyControlGroup;
    (async () => {
      var _await$getCreationOpt;
      // Lazy loading all services is required in this component because it is exported and contributes to the bundle size.
      const {
        pluginServices
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../services/plugin_services')));
      const {
        embeddable
      } = pluginServices.getServices();
      const factory = embeddable.getEmbeddableFactory(_types.CONTROL_GROUP_TYPE);
      const {
        initialInput,
        settings,
        fieldFilterPredicate
      } = (_await$getCreationOpt = await (getCreationOptions === null || getCreationOptions === void 0 ? void 0 : getCreationOptions((0, _common.getDefaultControlGroupInput)(), _control_group_input_builder.controlGroupInputBuilder))) !== null && _await$getCreationOpt !== void 0 ? _await$getCreationOpt : {};
      const newControlGroup = await (factory === null || factory === void 0 ? void 0 : factory.create({
        id,
        ...(0, _common.getDefaultControlGroupInput)(),
        ...initialInput
      }, undefined, settings, fieldFilterPredicate));
      if (canceled) {
        newControlGroup.destroy();
        controlGroup === null || controlGroup === void 0 ? void 0 : controlGroup.destroy();
        return;
      }
      if (controlGroupDomRef.current) {
        newControlGroup.render(controlGroupDomRef.current);
      }
      setControlGroup(newControlGroup);
      destroyControlGroup = () => newControlGroup.destroy();
    })();
    return () => {
      var _destroyControlGroup;
      canceled = true;
      (_destroyControlGroup = destroyControlGroup) === null || _destroyControlGroup === void 0 ? void 0 : _destroyControlGroup();
    };
    // exhaustive deps disabled because we want the control group to be created only on first render.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    var _controlGroup$getInpu;
    if (!controlGroup) return;
    if (timeRange && !(0, _lodash.isEqual)(controlGroup.getInput().timeRange, timeRange) || !(0, _esQuery.compareFilters)((_controlGroup$getInpu = controlGroup.getInput().filters) !== null && _controlGroup$getInpu !== void 0 ? _controlGroup$getInpu : [], filters !== null && filters !== void 0 ? filters : []) || !(0, _lodash.isEqual)(controlGroup.getInput().query, query)) {
      controlGroup.updateInput({
        timeRange,
        query,
        filters
      });
    }
  }, [query, filters, controlGroup, timeRange]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: controlGroupDomRef
  });
});
exports.ControlGroupRenderer = ControlGroupRenderer;