"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openAddDataControlFlyout = openAddDataControlFlyout;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _control_group_container = require("../embeddable/control_group_container");
var _control_group_constants = require("../../../common/control_group/control_group_constants");
var _services = require("../../services");
var _control_editor = require("./control_editor");
var _control_group_strings = require("../control_group_strings");
var _ = require("../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function openAddDataControlFlyout(options) {
  var _this$getInput$defaul, _this$getInput$defaul2;
  const {
    controlInputTransform,
    onSave
  } = options || {};
  const {
    overlays: {
      openFlyout,
      openConfirm
    },
    controls: {
      getControlFactory
    },
    theme: {
      theme$
    }
  } = _services.pluginServices.getServices();
  let controlInput = {};
  const onCancel = () => {
    if (Object.keys(controlInput).length === 0) {
      this.closeAllFlyouts();
      return;
    }
    openConfirm(_control_group_strings.ControlGroupStrings.management.discardNewControl.getSubtitle(), {
      confirmButtonText: _control_group_strings.ControlGroupStrings.management.discardNewControl.getConfirm(),
      cancelButtonText: _control_group_strings.ControlGroupStrings.management.discardNewControl.getCancel(),
      title: _control_group_strings.ControlGroupStrings.management.discardNewControl.getTitle(),
      buttonColor: 'danger'
    }).then(confirmed => {
      if (confirmed) {
        this.closeAllFlyouts();
      }
    });
  };
  const flyoutInstance = openFlyout((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_control_group_container.ControlGroupContainerContext.Provider, {
    value: this
  }, /*#__PURE__*/_react.default.createElement(_control_editor.ControlEditor, {
    setLastUsedDataViewId: newId => this.setLastUsedDataViewId(newId),
    getRelevantDataViewId: this.getMostRelevantDataViewId,
    isCreate: true,
    width: (_this$getInput$defaul = this.getInput().defaultControlWidth) !== null && _this$getInput$defaul !== void 0 ? _this$getInput$defaul : _control_group_constants.DEFAULT_CONTROL_WIDTH,
    grow: (_this$getInput$defaul2 = this.getInput().defaultControlGrow) !== null && _this$getInput$defaul2 !== void 0 ? _this$getInput$defaul2 : _control_group_constants.DEFAULT_CONTROL_GROW,
    updateTitle: newTitle => controlInput.title = newTitle,
    updateWidth: defaultControlWidth => this.updateInput({
      defaultControlWidth
    }),
    updateGrow: defaultControlGrow => this.updateInput({
      defaultControlGrow
    }),
    onSave: async type => {
      this.closeAllFlyouts();
      if (!type) {
        return;
      }
      const factory = getControlFactory(type);
      if (factory.presaveTransformFunction) {
        controlInput = factory.presaveTransformFunction(controlInput);
      }
      if (controlInputTransform) {
        controlInput = controlInputTransform({
          ...controlInput
        }, type);
      }
      let newControl;
      switch (type) {
        case _.OPTIONS_LIST_CONTROL:
          newControl = await this.addOptionsListControl(controlInput);
          break;
        case _.RANGE_SLIDER_CONTROL:
          newControl = await this.addRangeSliderControl(controlInput);
          break;
        default:
          newControl = await this.addDataControlFromField(controlInput);
      }
      if (onSave && !(0, _public2.isErrorEmbeddable)(newControl)) {
        onSave(newControl.id);
      }
    },
    onCancel: onCancel,
    onTypeEditorChange: partialInput => controlInput = {
      ...controlInput,
      ...partialInput
    }
  })), {
    theme$
  }), {
    'aria-label': _control_group_strings.ControlGroupStrings.manageControl.getFlyoutCreateTitle(),
    outsideClickCloses: false,
    onClose: () => {
      onCancel();
    },
    // @ts-ignore - TODO: Remove this once https://github.com/elastic/eui/pull/6645 lands in Kibana
    focusTrapProps: {
      scrollLock: true
    }
  });
  (0, _control_group_container.setFlyoutRef)(flyoutInstance);
}