"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/presentation-util-plugin/public");
var _control_group_strings = require("../control_group_strings");
var _editor_constants = require("./editor_constants");
var _services = require("../../services");
var _data_control_editor_tools = require("./data_control_editor_tools");
var _control_group_container = require("../embeddable/control_group_container");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldPicker = (0, _public.withSuspense)(_public.LazyFieldPicker, null);
const DataViewPicker = (0, _public.withSuspense)(_public.LazyDataViewPicker, null);
const ControlEditor = ({
  embeddable,
  isCreate,
  title,
  width,
  grow,
  onSave,
  onCancel,
  removeControl,
  updateGrow,
  updateTitle,
  updateWidth,
  onTypeEditorChange,
  getRelevantDataViewId,
  setLastUsedDataViewId
}) => {
  var _selectedDataView$get;
  const {
    dataViews: {
      getIdsWithTitle,
      getDefaultId,
      get
    },
    controls: {
      getControlFactory
    }
  } = _services.pluginServices.getServices();
  const controlGroup = (0, _control_group_container.useControlGroupContainer)();
  const editorConfig = controlGroup.select(state => state.componentState.editorConfig);
  const [defaultTitle, setDefaultTitle] = (0, _react.useState)();
  const [currentTitle, setCurrentTitle] = (0, _react.useState)(title !== null && title !== void 0 ? title : '');
  const [currentWidth, setCurrentWidth] = (0, _react.useState)(width);
  const [currentGrow, setCurrentGrow] = (0, _react.useState)(grow);
  const [controlEditorValid, setControlEditorValid] = (0, _react.useState)(false);
  const [selectedField, setSelectedField] = (0, _react.useState)(embeddable ? embeddable.getInput().fieldName : undefined);
  const [selectedDataViewId, setSelectedDataViewId] = (0, _react.useState)();
  (0, _useMount.default)(() => {
    let mounted = true;
    if (selectedField) setDefaultTitle(selectedField);
    (async () => {
      var _ref, _embeddable$getInput$;
      if (!mounted) return;
      const initialId = (_ref = (_embeddable$getInput$ = embeddable === null || embeddable === void 0 ? void 0 : embeddable.getInput().dataViewId) !== null && _embeddable$getInput$ !== void 0 ? _embeddable$getInput$ : getRelevantDataViewId === null || getRelevantDataViewId === void 0 ? void 0 : getRelevantDataViewId()) !== null && _ref !== void 0 ? _ref : await getDefaultId();
      if (initialId) {
        onTypeEditorChange({
          dataViewId: initialId
        });
        setSelectedDataViewId(initialId);
      }
    })();
    return () => {
      mounted = false;
    };
  });
  const {
    loading: dataViewListLoading,
    value: dataViewListItems = []
  } = (0, _useAsync.default)(() => {
    return getIdsWithTitle();
  });
  const {
    loading: dataViewLoading,
    value: {
      selectedDataView,
      fieldRegistry
    } = {
      selectedDataView: undefined,
      fieldRegistry: undefined
    }
  } = (0, _useAsync.default)(async () => {
    if (!selectedDataViewId) {
      return;
    }
    const dataView = await get(selectedDataViewId);
    const registry = await (0, _data_control_editor_tools.getDataControlFieldRegistry)(dataView);
    return {
      selectedDataView: dataView,
      fieldRegistry: registry
    };
  }, [selectedDataViewId]);
  (0, _react.useEffect)(() => setControlEditorValid(Boolean(selectedField) && Boolean(selectedDataView)), [selectedField, setControlEditorValid, selectedDataView]);
  const controlType = selectedField && fieldRegistry && fieldRegistry[selectedField].compatibleControlTypes[0];
  const factory = controlType && getControlFactory(controlType);
  const CustomSettings = factory && factory.controlEditorOptionsComponent;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, isCreate ? _control_group_strings.ControlGroupStrings.manageControl.getFlyoutCreateTitle() : _control_group_strings.ControlGroupStrings.manageControl.getFlyoutEditTitle()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "control-editor-flyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, !(editorConfig !== null && editorConfig !== void 0 && editorConfig.hideDataViewSelector) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.manageControl.getDataViewTitle()
  }, /*#__PURE__*/_react.default.createElement(DataViewPicker, {
    dataViews: dataViewListItems,
    selectedDataViewId: selectedDataViewId,
    onChangeDataViewId: dataViewId => {
      setLastUsedDataViewId === null || setLastUsedDataViewId === void 0 ? void 0 : setLastUsedDataViewId(dataViewId);
      if (dataViewId === selectedDataViewId) return;
      onTypeEditorChange({
        dataViewId
      });
      setSelectedField(undefined);
      setSelectedDataViewId(dataViewId);
    },
    trigger: {
      label: (_selectedDataView$get = selectedDataView === null || selectedDataView === void 0 ? void 0 : selectedDataView.getName()) !== null && _selectedDataView$get !== void 0 ? _selectedDataView$get : _control_group_strings.ControlGroupStrings.manageControl.getSelectDataViewMessage()
    },
    selectableProps: {
      isLoading: dataViewListLoading
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.manageControl.getFieldTitle()
  }, /*#__PURE__*/_react.default.createElement(FieldPicker, {
    filterPredicate: field => {
      var _controlGroup$fieldFi, _controlGroup$fieldFi2;
      const customPredicate = (_controlGroup$fieldFi = (_controlGroup$fieldFi2 = controlGroup.fieldFilterPredicate) === null || _controlGroup$fieldFi2 === void 0 ? void 0 : _controlGroup$fieldFi2.call(controlGroup, field)) !== null && _controlGroup$fieldFi !== void 0 ? _controlGroup$fieldFi : true;
      return Boolean(fieldRegistry === null || fieldRegistry === void 0 ? void 0 : fieldRegistry[field.name]) && customPredicate;
    },
    selectedFieldName: selectedField,
    dataView: selectedDataView,
    onSelectField: field => {
      var _field$displayName;
      onTypeEditorChange({
        fieldName: field.name
      });
      const newDefaultTitle = (_field$displayName = field.displayName) !== null && _field$displayName !== void 0 ? _field$displayName : field.name;
      setDefaultTitle(newDefaultTitle);
      setSelectedField(field.name);
      if (!currentTitle || currentTitle === defaultTitle) {
        setCurrentTitle(newDefaultTitle);
        updateTitle(newDefaultTitle);
      }
    },
    selectableProps: {
      isLoading: dataViewListLoading || dataViewLoading
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.manageControl.getControlTypeTitle()
  }, factory ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: factory.getIconType()
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "control-editor-type"
  }, factory.getDisplayName())) : /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    "data-test-subj": "control-editor-type"
  }, _control_group_strings.ControlGroupStrings.manageControl.getSelectFieldMessage())), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.manageControl.getTitleInputTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "control-editor-title-input",
    placeholder: defaultTitle,
    value: currentTitle,
    onChange: e => {
      updateTitle(e.target.value || defaultTitle);
      setCurrentTitle(e.target.value);
    }
  })), !(editorConfig !== null && editorConfig !== void 0 && editorConfig.hideWidthSettings) && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.manageControl.getWidthInputTitle()
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    color: "primary",
    legend: _control_group_strings.ControlGroupStrings.management.controlWidth.getWidthSwitchLegend(),
    options: _editor_constants.CONTROL_WIDTH_OPTIONS,
    idSelected: currentWidth,
    onChange: newWidth => {
      setCurrentWidth(newWidth);
      updateWidth(newWidth);
    }
  }), updateGrow && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _control_group_strings.ControlGroupStrings.manageControl.getGrowSwitchTitle(),
    color: "primary",
    checked: currentGrow,
    onChange: () => {
      setCurrentGrow(!currentGrow);
      updateGrow(!currentGrow);
    },
    "data-test-subj": "control-editor-grow-switch"
  })))), !(editorConfig !== null && editorConfig !== void 0 && editorConfig.hideAdditionalSettings) && CustomSettings && factory.controlEditorOptionsComponent && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _control_group_strings.ControlGroupStrings.manageControl.getControlSettingsTitle()
  }, /*#__PURE__*/_react.default.createElement(CustomSettings, {
    onChange: onTypeEditorChange,
    initialInput: embeddable === null || embeddable === void 0 ? void 0 : embeddable.getInput(),
    fieldType: fieldRegistry === null || fieldRegistry === void 0 ? void 0 : fieldRegistry[selectedField].field.type
  })), removeControl && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": `delete-${title}`,
    iconType: "trash",
    flush: "left",
    color: "danger",
    onClick: () => {
      onCancel();
      removeControl();
    }
  }, _control_group_strings.ControlGroupStrings.management.getDeleteButtonTitle())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": `cancel-${title}`,
    "data-test-subj": "control-editor-cancel",
    iconType: "cross",
    onClick: () => onCancel()
  }, _control_group_strings.ControlGroupStrings.manageControl.getCancelTitle())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "aria-label": `save-${title}`,
    "data-test-subj": "control-editor-save",
    iconType: "check",
    color: "primary",
    disabled: !controlEditorValid,
    onClick: () => onSave(controlType)
  }, _control_group_strings.ControlGroupStrings.manageControl.getSaveChangesTitle())))));
};
exports.ControlEditor = ControlEditor;