"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlFrame = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/presentation-util-plugin/public");
var _control_group_container = require("../embeddable/control_group_container");
var _control_group_strings = require("../control_group_strings");
var _use_child_embeddable = require("../../hooks/use_child_embeddable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ControlFrameError = ({
  error
}) => {
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const popoverButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    iconSize: "m",
    iconType: "error",
    onClick: () => setPopoverOpen(open => !open),
    className: 'errorEmbeddableCompact__button',
    textProps: {
      className: 'errorEmbeddableCompact__text'
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "controls.frame.error.message",
    defaultMessage: "An error occurred. View more"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: popoverButton,
    isOpen: isPopoverOpen,
    className: "errorEmbeddableCompact__popover",
    anchorClassName: "errorEmbeddableCompact__popoverAnchor",
    closePopover: () => setPopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_public.Markdown, {
    markdown: error.message,
    openLinksInNewTab: true,
    "data-test-subj": "errorMessageMarkdown"
  }));
};
const ControlFrame = ({
  customPrepend,
  enableActions,
  embeddableId,
  embeddableType
}) => {
  var _ref;
  const embeddableRoot = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createRef(), []);
  const [fatalError, setFatalError] = (0, _react.useState)();
  const controlGroup = (0, _control_group_container.useControlGroupContainer)();
  const controlStyle = (0, _control_group_container.controlGroupSelector)(state => state.explicitInput.controlStyle);
  const viewMode = (0, _control_group_container.controlGroupSelector)(state => state.explicitInput.viewMode);
  const disabledActions = (0, _control_group_container.controlGroupSelector)(state => state.explicitInput.disabledActions);
  const embeddable = (0, _use_child_embeddable.useChildEmbeddable)({
    untilEmbeddableLoaded: controlGroup.untilEmbeddableLoaded.bind(controlGroup),
    embeddableType,
    embeddableId
  });
  const [title, setTitle] = (0, _react.useState)();
  const usingTwoLineLayout = controlStyle === 'twoLine';
  (0, _react.useEffect)(() => {
    if (embeddableRoot.current) {
      embeddable === null || embeddable === void 0 ? void 0 : embeddable.render(embeddableRoot.current);
    }
    const inputSubscription = embeddable === null || embeddable === void 0 ? void 0 : embeddable.getInput$().subscribe(newInput => setTitle(newInput.title));
    const errorSubscription = embeddable === null || embeddable === void 0 ? void 0 : embeddable.getOutput$().subscribe({
      error: setFatalError
    });
    return () => {
      inputSubscription === null || inputSubscription === void 0 ? void 0 : inputSubscription.unsubscribe();
      errorSubscription === null || errorSubscription === void 0 ? void 0 : errorSubscription.unsubscribe();
    };
  }, [embeddable, embeddableRoot]);
  const embeddableParentClassNames = (0, _classnames.default)('controlFrame__control', {
    'controlFrame--twoLine': controlStyle === 'twoLine',
    'controlFrame--oneLine': controlStyle === 'oneLine',
    'controlFrame--fatalError': !!fatalError
  });
  function renderEmbeddablePrepend() {
    if (typeof (embeddable === null || embeddable === void 0 ? void 0 : embeddable.renderPrepend) === 'function') {
      return embeddable.renderPrepend();
    }
    return usingTwoLineLayout ? undefined : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      anchorClassName: "controlFrame__labelToolTip",
      content: title
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      className: "controlFrame__formControlLayoutLabel",
      htmlFor: embeddableId
    }, title));
  }
  const form = /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    className: (0, _classnames.default)('controlFrame__formControlLayout', {
      'controlFrameFormControlLayout--twoLine': controlStyle === 'twoLine'
    }),
    fullWidth: true,
    prepend: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_ref = embeddable && customPrepend) !== null && _ref !== void 0 ? _ref : null, renderEmbeddablePrepend())
  }, embeddable && !fatalError && /*#__PURE__*/_react.default.createElement("div", {
    className: embeddableParentClassNames,
    id: `controlFrame--${embeddableId}`,
    ref: embeddableRoot
  }, fatalError && /*#__PURE__*/_react.default.createElement(ControlFrameError, {
    error: fatalError
  })), fatalError && /*#__PURE__*/_react.default.createElement("div", {
    className: embeddableParentClassNames,
    id: `controlFrame--${embeddableId}`
  }, /*#__PURE__*/_react.default.createElement(ControlFrameError, {
    error: fatalError
  })), !embeddable && /*#__PURE__*/_react.default.createElement("div", {
    className: embeddableParentClassNames,
    id: `controlFrame--${embeddableId}`
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "controlFrame--controlLoading"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, null))));
  return /*#__PURE__*/_react.default.createElement(_public2.FloatingActions, {
    className: (0, _classnames.default)({
      'controlFrameFloatingActions--twoLine': usingTwoLineLayout,
      'controlFrameFloatingActions--oneLine': !usingTwoLineLayout
    }),
    viewMode: viewMode,
    embeddable: embeddable,
    disabledActions: disabledActions,
    isEnabled: embeddable && enableActions
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "control-frame-title",
    fullWidth: true,
    label: usingTwoLineLayout ? title || _control_group_strings.ControlGroupStrings.emptyState.getTwoLineLoadingTitle() : undefined
  }, form));
};
exports.ControlFrame = ControlFrame;