"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditControlFlyout = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _services = require("../../services");
var _control_group_strings = require("../control_group_strings");
var _control_group_container = require("../embeddable/control_group_container");
var _control_editor = require("../editor/control_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EditControlFlyout = ({
  embeddable,
  closeFlyout,
  removeControl
}) => {
  // Controls Services Context
  const {
    overlays: {
      openConfirm
    },
    controls: {
      getControlFactory
    }
  } = _services.pluginServices.getServices();
  // Redux embeddable container Context
  const controlGroup = (0, _control_group_container.useControlGroupContainer)();

  // current state
  const panels = controlGroup.select(state => state.explicitInput.panels);
  const panel = panels[embeddable.id];
  const [currentGrow, setCurrentGrow] = (0, _react.useState)(panel.grow);
  const [currentWidth, setCurrentWidth] = (0, _react.useState)(panel.width);
  const [inputToReturn, setInputToReturn] = (0, _react.useState)({});
  const onCancel = () => {
    if ((0, _lodash.isEqual)(panel.explicitInput, {
      ...panel.explicitInput,
      ...inputToReturn
    }) && currentGrow === panel.grow && currentWidth === panel.width) {
      closeFlyout();
      return;
    }
    openConfirm(_control_group_strings.ControlGroupStrings.management.discardChanges.getSubtitle(), {
      confirmButtonText: _control_group_strings.ControlGroupStrings.management.discardChanges.getConfirm(),
      cancelButtonText: _control_group_strings.ControlGroupStrings.management.discardChanges.getCancel(),
      title: _control_group_strings.ControlGroupStrings.management.discardChanges.getTitle(),
      buttonColor: 'danger'
    }).then(confirmed => {
      if (confirmed) {
        closeFlyout();
      }
    });
  };
  const onSave = async type => {
    if (!type) {
      closeFlyout();
      return;
    }
    const factory = getControlFactory(type);
    if (!factory) throw new _public.EmbeddableFactoryNotFoundError(type);
    if (factory.presaveTransformFunction) {
      setInputToReturn(factory.presaveTransformFunction(inputToReturn, embeddable));
    }
    if (currentWidth !== panel.width) controlGroup.dispatch.setControlWidth({
      width: currentWidth,
      embeddableId: embeddable.id
    });
    if (currentGrow !== panel.grow) controlGroup.dispatch.setControlGrow({
      grow: currentGrow,
      embeddableId: embeddable.id
    });
    closeFlyout();
    await controlGroup.replaceEmbeddable(embeddable.id, inputToReturn, type);
  };
  return /*#__PURE__*/_react.default.createElement(_control_editor.ControlEditor, {
    isCreate: false,
    width: panel.width,
    grow: panel.grow,
    embeddable: embeddable,
    title: embeddable.getTitle(),
    onCancel: () => onCancel(),
    updateTitle: newTitle => inputToReturn.title = newTitle,
    setLastUsedDataViewId: lastUsed => controlGroup.setLastUsedDataViewId(lastUsed),
    updateWidth: newWidth => setCurrentWidth(newWidth),
    updateGrow: newGrow => setCurrentGrow(newGrow),
    onTypeEditorChange: partialInput => {
      setInputToReturn({
        ...inputToReturn,
        ...partialInput
      });
    },
    onSave: type => onSave(type),
    removeControl: () => {
      closeFlyout();
      removeControl();
    }
  });
};
exports.EditControlFlyout = EditControlFlyout;