"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteControlAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _ = require(".");
var _services = require("../../services");
var _control_group_strings = require("../control_group_strings");
var _control_group_helpers = require("../embeddable/control_group_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DeleteControlAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _.ACTION_DELETE_CONTROL);
    (0, _defineProperty2.default)(this, "id", _.ACTION_DELETE_CONTROL);
    (0, _defineProperty2.default)(this, "order", 2);
    (0, _defineProperty2.default)(this, "openConfirm", void 0);
    (0, _defineProperty2.default)(this, "MenuItem", ({
      context
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: this.getDisplayName(context)
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": `control-action-${context.embeddable.id}-delete`,
        "aria-label": this.getDisplayName(context),
        iconType: this.getIconType(context),
        onClick: () => this.execute(context),
        color: "danger"
      }));
    });
    ({
      overlays: {
        openConfirm: this.openConfirm
      }
    } = _services.pluginServices.getServices());
  }
  getDisplayName({
    embeddable
  }) {
    if (!embeddable.parent || !(0, _control_group_helpers.isControlGroup)(embeddable.parent)) {
      throw new _public2.IncompatibleActionError();
    }
    return _control_group_strings.ControlGroupStrings.floatingActions.getRemoveButtonTitle();
  }
  getIconType({
    embeddable
  }) {
    if (!embeddable.parent || !(0, _control_group_helpers.isControlGroup)(embeddable.parent)) {
      throw new _public2.IncompatibleActionError();
    }
    return 'cross';
  }
  async isCompatible({
    embeddable
  }) {
    if ((0, _public.isErrorEmbeddable)(embeddable)) return false;
    const controlGroup = embeddable.parent;
    return Boolean(controlGroup && (0, _control_group_helpers.isControlGroup)(controlGroup) && controlGroup.getInput().viewMode === _public.ViewMode.EDIT);
  }
  async execute({
    embeddable
  }) {
    if (!embeddable.parent || !(0, _control_group_helpers.isControlGroup)(embeddable.parent)) {
      throw new _public2.IncompatibleActionError();
    }
    this.openConfirm(_control_group_strings.ControlGroupStrings.management.deleteControls.getSubtitle(), {
      confirmButtonText: _control_group_strings.ControlGroupStrings.management.deleteControls.getConfirm(),
      cancelButtonText: _control_group_strings.ControlGroupStrings.management.deleteControls.getCancel(),
      title: _control_group_strings.ControlGroupStrings.management.deleteControls.getDeleteTitle(),
      buttonColor: 'danger'
    }).then(confirmed => {
      if (confirmed) {
        var _embeddable$parent;
        (_embeddable$parent = embeddable.parent) === null || _embeddable$parent === void 0 ? void 0 : _embeddable$parent.removeEmbeddable(embeddable.id);
      }
    });
  }
}
exports.DeleteControlAction = DeleteControlAction;