"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentManagementPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classPrivateFieldGet2 = _interopRequireDefault(require("@babel/runtime/helpers/classPrivateFieldGet"));
var _core = require("./core");
var _rpc = require("./rpc");
var _rpc2 = require("../common/rpc");
function _classPrivateFieldInitSpec(obj, privateMap, value) { _checkPrivateRedeclaration(obj, privateMap); privateMap.set(obj, value); }
function _checkPrivateRedeclaration(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
var _eventStream = /*#__PURE__*/new WeakMap();
class ContentManagementPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "core", void 0);
    _classPrivateFieldInitSpec(this, _eventStream, {
      writable: true,
      value: void 0
    });
    this.logger = initializerContext.logger.get();

    // TODO: Enable Event Stream once we ready to log events.
    // const kibanaVersion = initializerContext.env.packageInfo.version;
    // this.#eventStream = new EventStreamService({
    //   logger: this.logger,
    //   clientFactory: new EsEventStreamClientFactory({
    //     baseName: '.kibana',
    //     kibanaVersion,
    //     logger: this.logger,
    //   }),
    // });

    this.core = new _core.Core({
      logger: this.logger,
      eventStream: (0, _classPrivateFieldGet2.default)(this, _eventStream)
    });
  }
  setup(core) {
    if ((0, _classPrivateFieldGet2.default)(this, _eventStream)) {
      (0, _classPrivateFieldGet2.default)(this, _eventStream).setup({
        core
      });
    }
    const {
      api: coreApi,
      contentRegistry
    } = this.core.setup();
    const rpc = new _rpc.RpcService();
    (0, _rpc.registerProcedures)(rpc);
    const router = core.http.createRouter();
    (0, _rpc.initRpcRoutes)(_rpc2.procedureNames, router, {
      rpc,
      contentRegistry
    });
    return {
      ...coreApi
    };
  }
  start(core) {
    if ((0, _classPrivateFieldGet2.default)(this, _eventStream)) {
      (0, _classPrivateFieldGet2.default)(this, _eventStream).start();
    }
    return {};
  }
  async stop() {
    if ((0, _classPrivateFieldGet2.default)(this, _eventStream)) {
      try {
        await (0, _classPrivateFieldGet2.default)(this, _eventStream).stop();
      } catch (e) {
        this.logger.error(`Error during event stream stop: ${e}`);
      }
    }
  }
}
exports.ContentManagementPlugin = ContentManagementPlugin;