"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSchemas = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("./common");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createSchemas = {
  in: _configSchema.schema.object({
    contentTypeId: _configSchema.schema.string(),
    version: _constants.versionSchema,
    // --> "data" to create a content will be defined by each content type
    data: _configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()),
    options: _configSchema.schema.maybe(_configSchema.schema.object({}, {
      unknowns: 'allow'
    }))
  }, {
    unknowns: 'forbid'
  }),
  out: _configSchema.schema.object({
    contentTypeId: _configSchema.schema.string(),
    result: _common.itemResultSchema
  }, {
    unknowns: 'forbid'
  })
};
exports.createSchemas = createSchemas;