"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConstantComponent = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
var _shared_component = require("./shared_component");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ConstantComponent extends _shared_component.SharedComponent {
  constructor(name, parent, options) {
    super(name, parent);
    if (_lodash.default.isString(options)) {
      options = [options];
    }
    this.options = options || [name];
  }
  getTerms() {
    return this.options;
  }
  addOption(options) {
    if (!Array.isArray(options)) {
      options = [options];
    }
    [].push.apply(this.options, options);
    this.options = _lodash.default.uniq(this.options);
  }
  match(token, context, editor) {
    if (token !== this.name) {
      return null;
    }
    return super.match(token, context, editor);
  }
}
exports.ConstantComponent = ConstantComponent;