"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEsHostService = exports.EsHostService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Very simple state for holding the current ES host.
 *
 * This is used to power the copy as cURL functionality.
 */
class EsHostService {
  constructor(api) {
    (0, _defineProperty2.default)(this, "host", 'http://localhost:9200');
    this.api = api;
  }
  setHost(host) {
    this.host = host;
  }

  /**
   * Initialize the host value based on the value set on the server.
   *
   * This call is necessary because this value can only be retrieved at
   * runtime.
   */
  async init() {
    const {
      data
    } = await this.api.getEsConfig();
    if (data && data.host) {
      this.setHost(data.host);
    }
  }
  getHost() {
    return this.host;
  }
}
exports.EsHostService = EsHostService;
const createEsHostService = ({
  api
}) => new EsHostService(api);
exports.createEsHostService = createEsHostService;