"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRestoreRequestFromHistory = void 0;
var _react = require("react");
var _editor_registry = require("../../contexts/editor_context/editor_registry");
var _restore_request_from_history = require("./restore_request_from_history");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useRestoreRequestFromHistory = () => {
  return (0, _react.useCallback)(req => {
    const editor = _editor_registry.instance.getInputEditor();
    (0, _restore_request_from_history.restoreRequestFromHistory)(editor, req);
  }, []);
};
exports.useRestoreRequestFromHistory = useRestoreRequestFromHistory;