"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Variables = Variables;
var _react = _interopRequireDefault(require("react"));
var _components = require("../components");
var _contexts = require("../contexts");
var _services = require("../../services");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function Variables({
  onClose
}) {
  const {
    services: {
      storage
    }
  } = (0, _contexts.useServicesContext)();
  const onSaveVariables = newVariables => {
    storage.set(_services.StorageKeys.VARIABLES, newVariables);
    onClose();
  };
  return /*#__PURE__*/_react.default.createElement(_components.DevToolsVariablesFlyout, {
    onClose: onClose,
    onSaveVariables: onSaveVariables,
    variables: storage.get(_services.StorageKeys.VARIABLES, _constants.DEFAULT_VARIABLES)
  });
}