"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applyCurrentSettings = applyCurrentSettings;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function applyCurrentSettings(editor, settings) {
  if (editor.setStyles) {
    editor.setStyles({
      wrapLines: settings.wrapMode,
      fontSize: settings.fontSize + 'px'
    });
  } else {
    editor.getSession().setUseWrapMode(settings.wrapMode);
    editor.container.style.fontSize = settings.fontSize + 'px';
  }
}