"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _sense_editor = require("../models/sense_editor");
var _input = require("../models/legacy_core_editor/mode/input");
var _output = require("../models/legacy_core_editor/mode/output");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// @ts-ignore

const exampleText = `
GET _search
{
  "query": {
    "match_all": {}
  }
}
`;
const EditorExample = ({
  panel,
  example,
  theme,
  linesOfExampleCode = 6,
  mode = 'input'
}) => {
  const inputId = `help-example-${panel}-input`;
  const wrapperDivRef = (0, _react.useRef)(null);
  const editorRef = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    if (wrapperDivRef.current) {
      editorRef.current = (0, _sense_editor.createReadOnlyAceEditor)(wrapperDivRef.current);
      const editor = editorRef.current;
      const editorMode = mode === 'input' ? new _input.Mode() : new _output.Mode();
      editor.update((example || exampleText).trim(), editorMode);
      editor.session.setUseWorker(false);
      editor.setHighlightActiveLine(false);
      const textareaElement = wrapperDivRef.current.querySelector('textarea');
      if (textareaElement) {
        textareaElement.setAttribute('id', inputId);
        textareaElement.setAttribute('readonly', 'true');
      }
    }
    return () => {
      if (editorRef.current) {
        editorRef.current.destroy();
      }
    };
  }, [example, inputId, mode]);
  const wrapperDivStyle = {
    height: `${parseInt(theme.euiTheme.size.base, 10) * linesOfExampleCode}px`,
    margin: `${theme.euiTheme.size.base} 0`
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: inputId
  }, _i18n.i18n.translate('console.exampleOutputTextarea', {
    defaultMessage: 'Dev Tools Console editor example'
  }))), /*#__PURE__*/_react.default.createElement("div", {
    ref: wrapperDivRef,
    className: "conApp_example",
    css: wrapperDivStyle
  }));
};

// eslint-disable-next-line import/no-default-export
var _default = (0, _eui.withEuiTheme)(EditorExample);
exports.default = _default;
module.exports = exports.default;