"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CspPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _classPrivateFieldSet2 = _interopRequireDefault(require("@babel/runtime/helpers/classPrivateFieldSet"));
var _classPrivateFieldGet2 = _interopRequireDefault(require("@babel/runtime/helpers/classPrivateFieldGet"));
var _helpers = require("../common/utils/helpers");
var _subscription = require("../common/utils/subscription");
var _setup_routes = require("./routes/setup_routes");
var _saved_objects = require("./saved_objects");
var _create_indices = require("./create_indices/create_indices");
var _create_transforms = require("./create_transforms/create_transforms");
var _fleet_integration = require("./fleet_integration/fleet_integration");
var _constants = require("../common/constants");
var _findings_stats_task = require("./tasks/findings_stats_task");
var _register = require("./lib/telemetry/collectors/register");
function _classPrivateFieldInitSpec(obj, privateMap, value) { _checkPrivateRedeclaration(obj, privateMap); privateMap.set(obj, value); }
function _checkPrivateRedeclaration(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
var _isInitialized = /*#__PURE__*/new WeakMap();
class CspPlugin {
  /**
   * CSP is initialized when the Fleet package is installed.
   * either directly after installation, or
   * when the plugin is started and a package is present.
   */

  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "isCloudEnabled", void 0);
    _classPrivateFieldInitSpec(this, _isInitialized, {
      writable: true,
      value: false
    });
    this.logger = initializerContext.logger.get();
  }
  setup(core, plugins) {
    (0, _saved_objects.setupSavedObjects)(core.savedObjects);
    (0, _setup_routes.setupRoutes)({
      core,
      logger: this.logger,
      isPluginInitialized: () => (0, _classPrivateFieldGet2.default)(this, _isInitialized)
    });
    const coreStartServices = core.getStartServices();
    this.setupCspTasks(plugins.taskManager, coreStartServices, this.logger);
    (0, _register.registerCspmUsageCollector)(this.logger, coreStartServices, plugins.usageCollection);
    this.isCloudEnabled = plugins.cloud.isCloudEnabled;
    return {};
  }
  start(core, plugins) {
    plugins.fleet.fleetSetupCompleted().then(async () => {
      const packageInfo = await plugins.fleet.packageService.asInternalUser.getInstallation(_constants.CLOUD_SECURITY_POSTURE_PACKAGE_NAME);

      // If package is installed we want to make sure all needed assets are installed
      if (packageInfo) {
        // noinspection ES6MissingAwait
        this.initialize(core, plugins.taskManager);
      }
      plugins.fleet.registerExternalCallback('packagePolicyCreate', async packagePolicy => {
        var _packagePolicy$packag;
        const license = await plugins.licensing.refresh();
        if ((0, _helpers.isCspPackage)((_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name)) {
          if (!(0, _subscription.isSubscriptionAllowed)(this.isCloudEnabled, license)) {
            throw new Error('To use this feature you must upgrade your subscription or start a trial');
          }
          if (!isSingleEnabledInput(packagePolicy.inputs)) {
            throw new Error('Only one enabled input is allowed per policy');
          }
        }
        return packagePolicy;
      });
      plugins.fleet.registerExternalCallback('packagePolicyPostCreate', async (packagePolicy, soClient) => {
        var _packagePolicy$packag2;
        if ((0, _helpers.isCspPackage)((_packagePolicy$packag2 = packagePolicy.package) === null || _packagePolicy$packag2 === void 0 ? void 0 : _packagePolicy$packag2.name)) {
          await this.initialize(core, plugins.taskManager);
          await (0, _fleet_integration.onPackagePolicyPostCreateCallback)(this.logger, packagePolicy, soClient);
          return packagePolicy;
        }
        return packagePolicy;
      });
      plugins.fleet.registerExternalCallback('packagePolicyPostDelete', async deletedPackagePolicies => {
        for (const deletedPackagePolicy of deletedPackagePolicies) {
          var _deletedPackagePolicy;
          if ((0, _helpers.isCspPackage)((_deletedPackagePolicy = deletedPackagePolicy.package) === null || _deletedPackagePolicy === void 0 ? void 0 : _deletedPackagePolicy.name)) {
            const soClient = core.savedObjects.createInternalRepository();
            const packagePolicyService = plugins.fleet.packagePolicyService;
            const isPackageExists = await (0, _fleet_integration.isCspPackagePolicyInstalled)(packagePolicyService, soClient, this.logger);
            if (!isPackageExists) {
              await this.uninstallResources(plugins.taskManager, this.logger);
            }
          }
        }
      });
    });
    return {};
  }
  stop() {}

  /**
   * Initialization is idempotent and required for (re)creating indices and transforms.
   */
  async initialize(core, taskManager) {
    this.logger.debug('initialize');
    const esClient = core.elasticsearch.client.asInternalUser;
    await (0, _create_indices.initializeCspIndices)(esClient, this.logger);
    await (0, _create_transforms.initializeCspTransforms)(esClient, this.logger);
    await (0, _findings_stats_task.scheduleFindingsStatsTask)(taskManager, this.logger);
    (0, _classPrivateFieldSet2.default)(this, _isInitialized, true);
  }
  async uninstallResources(taskManager, logger) {
    await (0, _findings_stats_task.removeFindingsStatsTask)(taskManager, logger);
  }
  setupCspTasks(taskManager, coreStartServices, logger) {
    (0, _findings_stats_task.setupFindingsStatsTask)(taskManager, coreStartServices, logger);
  }
}
exports.CspPlugin = CspPlugin;
const isSingleEnabledInput = inputs => inputs.filter(i => i.enabled).length === 1;