"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityFindingFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _vulnerability_overview_tab = require("./vulnerability_overview_tab");
var _vulnerability_json_tab = require("./vulnerability_json_tab");
var _vulnerability_badges = require("../../../components/vulnerability_badges");
var _test_subjects = require("../test_subjects");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const overviewTabId = 'overview';
const jsonTabId = 'json';
const VulnerabilityFindingFlyout = ({
  closeFlyout,
  onPaginate,
  totalVulnerabilitiesCount,
  flyoutIndex,
  vulnerabilityRecord
}) => {
  var _vulnerabilityRecord$, _vulnerabilityRecord$2, _vulnerability$cvss, _vulnerability$packag, _vulnerability$packag2;
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(overviewTabId);
  const vulnerability = vulnerabilityRecord === null || vulnerabilityRecord === void 0 ? void 0 : vulnerabilityRecord.vulnerability;
  const resourceName = vulnerabilityRecord === null || vulnerabilityRecord === void 0 ? void 0 : (_vulnerabilityRecord$ = vulnerabilityRecord.resource) === null || _vulnerabilityRecord$ === void 0 ? void 0 : _vulnerabilityRecord$.name;
  const tabs = (0, _react.useMemo)(() => [{
    id: overviewTabId,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.overviewTabLabel",
      defaultMessage: "Overview"
    }),
    content: /*#__PURE__*/_react.default.createElement(_vulnerability_overview_tab.VulnerabilityOverviewTab, {
      vulnerability: vulnerability
    })
  }, {
    id: jsonTabId,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.jsonTabLabel",
      defaultMessage: "JSON"
    }),
    content: /*#__PURE__*/_react.default.createElement(_vulnerability_json_tab.VulnerabilityJsonTab, {
      vulnerabilityRecord: vulnerabilityRecord
    })
  }], [vulnerability, vulnerabilityRecord]);
  const onSelectedTabChanged = id => setSelectedTabId(id);
  const renderTabs = () => tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    "data-test-subj": (0, _test_subjects.TAB_ID_VULNERABILITY_FLYOUT)(tab.id),
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    key: index
  }, tab.name));
  const selectedTabContent = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  }, [selectedTabId, tabs]);
  const nvdDomain = 'https://nvd';
  const nvdWebsite = `${nvdDomain}.nist.gov/vuln/detail/${vulnerabilityRecord === null || vulnerabilityRecord === void 0 ? void 0 : (_vulnerabilityRecord$2 = vulnerabilityRecord.vulnerability) === null || _vulnerabilityRecord$2 === void 0 ? void 0 : _vulnerabilityRecord$2.id}`;
  const vulnerabilityReference = vulnerability !== null && vulnerability !== void 0 && (_vulnerability$cvss = vulnerability.cvss) !== null && _vulnerability$cvss !== void 0 && _vulnerability$cvss.nvd ? nvdWebsite : vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.reference;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: (0, _react2.css)`
            gap: ${_uiTheme.euiThemeVars.euiSizeS};
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_vulnerability_badges.SeverityStatusBadge, {
    status: vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.severity
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    css: (0, _react2.css)`
                gap: ${_uiTheme.euiThemeVars.euiSizeS};
              `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    css: (0, _react2.css)`
                    color: ${_uiTheme.euiThemeVars.euiColorPrimaryText};
                    line-height: 32px;
                  `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: '_blank',
    href: vulnerabilityReference
  }, vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("p", {
    css: (0, _react2.css)`
                    line-height: 20px;
                    margin-bottom: ${_uiTheme.euiThemeVars.euiSizeM};
                  `
  }, `${resourceName} | ${vulnerability === null || vulnerability === void 0 ? void 0 : (_vulnerability$packag = vulnerability.package) === null || _vulnerability$packag === void 0 ? void 0 : _vulnerability$packag.name}  ${vulnerability === null || vulnerability === void 0 ? void 0 : (_vulnerability$packag2 = vulnerability.package) === null || _vulnerability$packag2 === void 0 ? void 0 : _vulnerability$packag2.version}`)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, renderTabs())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, selectedTabContent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    pageCount: totalVulnerabilitiesCount,
    activePage: flyoutIndex,
    onPageClick: onPaginate,
    compressed: true
  })))));
};
exports.VulnerabilityFindingFlyout = VulnerabilityFindingFlyout;